/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.nbt.impl;

import io.fairyproject.bukkit.nbt.NBTKey;
import io.fairyproject.bukkit.nbt.NBTModifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NBTModifierMock
implements NBTModifier {
    private final Map<Object, Map<NBTKey, Object>> cache = new IdentityHashMap<Object, Map<NBTKey, Object>>(4);

    private Map<NBTKey, Object> getMap(Object holder) {
        return this.cache.computeIfAbsent(holder, i -> new ConcurrentHashMap());
    }

    public Object getTag(Object holder, NBTKey key) {
        return this.getMap(holder).get(key);
    }

    @Override
    public boolean has(Object holder, NBTKey key) {
        return this.getMap(holder).containsKey(key);
    }

    @Override
    public boolean getBoolean(Object holder, NBTKey key) {
        return (Boolean)this.getTag(holder, key);
    }

    @Override
    public long getLong(Object holder, NBTKey key) {
        return (Long)this.getTag(holder, key);
    }

    @Override
    public int getInt(Object holder, NBTKey key) {
        return (Integer)this.getTag(holder, key);
    }

    @Override
    public short getShort(Object holder, NBTKey key) {
        return (Short)this.getTag(holder, key);
    }

    @Override
    public double getDouble(Object holder, NBTKey key) {
        return (Double)this.getTag(holder, key);
    }

    @Override
    public float getFloat(Object holder, NBTKey key) {
        return ((Float)this.getTag(holder, key)).floatValue();
    }

    @Override
    public String getString(Object holder, NBTKey key) {
        return (String)this.getTag(holder, key);
    }

    @Override
    public <T> T setTag(T holder, NBTKey key, Object value) {
        this.getMap(holder).put(key, value);
        return holder;
    }
}

