/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.nms;

import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.reflection.resolver.minecraft.NMSClassResolver;
import io.fairyproject.bukkit.reflection.resolver.minecraft.OBCClassResolver;
import io.fairyproject.bukkit.version.OBCVersionDecoder;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.mc.MCServer;
import io.fairyproject.mc.version.MCVersionMapping;
import io.fairyproject.mc.version.MCVersionMappingRegistry;

public class BukkitNMSManagerImpl
implements BukkitNMSManager {
    private final Class<?> serverClass;
    private final MCServer mcServer;
    private final MCVersionMappingRegistry versionMappingRegistry;
    private NMSClassResolver nmsClassResolver;
    private OBCClassResolver obcClassResolver;

    public BukkitNMSManagerImpl(MCServer mcServer, MCVersionMappingRegistry versionMappingRegistry, Class<?> serverClass) {
        this.serverClass = serverClass;
        this.mcServer = mcServer;
        this.versionMappingRegistry = versionMappingRegistry;
    }

    @PreInitialize
    public void onPreInitialize() {
        this.nmsClassResolver = this.setupNmsClassResolver();
        this.obcClassResolver = this.setupObcClassResolver();
    }

    private OBCClassResolver setupObcClassResolver() {
        return new OBCClassResolver(this.serverClass.getPackage().getName() + ".");
    }

    private NMSClassResolver setupNmsClassResolver() {
        MCVersionMapping mapping = this.versionMappingRegistry.findMapping(this.mcServer.getVersion());
        if (mapping.isNmsPrefix()) {
            String versionFormat = OBCVersionDecoder.create().decode(this.serverClass);
            return new NMSClassResolver("net.minecraft.server." + versionFormat + ".");
        }
        return new NMSClassResolver("net.minecraft.");
    }

    public Class<?> getServerClass() {
        return this.serverClass;
    }

    @Override
    public MCServer getMcServer() {
        return this.mcServer;
    }

    @Override
    public MCVersionMappingRegistry getVersionMappingRegistry() {
        return this.versionMappingRegistry;
    }

    @Override
    public NMSClassResolver getNmsClassResolver() {
        return this.nmsClassResolver;
    }

    @Override
    public OBCClassResolver getObcClassResolver() {
        return this.obcClassResolver;
    }
}

