/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.reflection;

import io.fairyproject.Debug;
import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.reflection.resolver.ConstructorResolver;
import io.fairyproject.bukkit.reflection.resolver.FieldResolver;
import io.fairyproject.bukkit.reflection.resolver.MethodResolver;
import io.fairyproject.util.AccessUtil;
import io.fairyproject.util.EquivalentConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.bukkit.entity.Entity;

@Deprecated
public class MinecraftReflection {
    public static String NETTY_PREFIX;
    private static Class<?> NMS_ENTITY;
    private static Class<?> CRAFT_ENTITY;
    public static Class<?> CHANNEL_TYPE;
    public static Class<?> GAME_PROFILE_TYPE;

    public static void init(BukkitNMSManager nmsManager) {
        if (Debug.UNIT_TEST) {
            return;
        }
        try {
            NMS_ENTITY = nmsManager.getNmsClassResolver().resolve("world.entity.Entity", "Entity");
            CRAFT_ENTITY = nmsManager.getObcClassResolver().resolve("entity.CraftEntity");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        try {
            CHANNEL_TYPE = Class.forName("io.netty.channel.Channel");
            NETTY_PREFIX = "io.netty.";
        }
        catch (ClassNotFoundException ex) {
            try {
                CHANNEL_TYPE = Class.forName("net.minecraft.util.io.netty.channel.Channel");
                NETTY_PREFIX = "net.minecraft.util.io.netty.";
            }
            catch (ClassNotFoundException ex2) {
                throw new IllegalStateException("Coulnd't find netty Channel class!", ex2);
            }
        }
        try {
            GAME_PROFILE_TYPE = Class.forName("com.mojang.authlib.GameProfile");
        }
        catch (ClassNotFoundException ex) {
            try {
                GAME_PROFILE_TYPE = Class.forName("net.minecraft.util.com.mojang.authlib.GameProfile");
            }
            catch (ClassNotFoundException ex2) {
                throw new IllegalStateException("Coulnd't find mojang GameProfile class!", ex2);
            }
        }
    }

    public static Object getHandle(Object object) throws ReflectiveOperationException {
        Method method;
        try {
            method = AccessUtil.setAccessible(object.getClass().getDeclaredMethod("getHandle", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            method = AccessUtil.setAccessible(CRAFT_ENTITY.getDeclaredMethod("getHandle", new Class[0]));
        }
        return method.invoke(object, new Object[0]);
    }

    public static Entity getBukkitEntity(Object object) throws ReflectiveOperationException {
        Method method;
        try {
            method = AccessUtil.setAccessible(NMS_ENTITY.getDeclaredMethod("getBukkitEntity", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            method = AccessUtil.setAccessible(CRAFT_ENTITY.getDeclaredMethod("getHandle", new Class[0]));
        }
        return (Entity)method.invoke(object, new Object[0]);
    }

    public static Object getHandleSilent(Object object) {
        try {
            return MinecraftReflection.getHandle(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public static Object newEnumInstance(Class clazz, Class[] types, Object[] values) throws ReflectiveOperationException {
        Constructor constructor = new ConstructorResolver(clazz).resolve(new Class[][]{types});
        Field accessorField = new FieldResolver(Constructor.class).resolve("constructorAccessor");
        Object constructorAccessor = accessorField.get(constructor);
        if (constructorAccessor == null) {
            new MethodResolver(Constructor.class).resolve("acquireConstructorAccessor").invoke((Object)constructor, new Object[0]);
            constructorAccessor = accessorField.get(constructor);
        }
        return new MethodResolver(constructorAccessor.getClass()).resolve("newInstance").invoke(constructorAccessor, new Object[]{values});
    }

    public static <T> EquivalentConverter<T> handle(final Function<T, Object> toHandle, final Function<Object, T> fromHandle) {
        return new EquivalentConverter<T>(){

            @Override
            public T getSpecific(Object generic) {
                return fromHandle.apply(generic);
            }

            @Override
            public Object getGeneric(T specific) {
                return toHandle.apply(specific);
            }

            @Override
            public Class<T> getSpecificType() {
                return null;
            }
        };
    }
}

