/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.scheduler.bukkit;

import io.fairyproject.bukkit.scheduler.bukkit.BukkitAbstractScheduler;
import io.fairyproject.bukkit.scheduler.bukkit.BukkitRepeatedScheduledTask;
import io.fairyproject.scheduler.ScheduledTask;
import io.fairyproject.scheduler.repeat.RepeatPredicate;
import io.fairyproject.scheduler.response.TaskResponse;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BukkitAsyncScheduler
extends BukkitAbstractScheduler {
    private final Plugin bukkitPlugin;

    @Override
    public boolean isCurrentThread() {
        return Thread.currentThread().getName().contains("Craft Scheduler Thread");
    }

    @Override
    public <R> ScheduledTask<R> schedule(Callable<R> callable) {
        return this.doSchedule(callable, task -> Bukkit.getScheduler().runTaskAsynchronously(this.bukkitPlugin, task));
    }

    @Override
    public <R> ScheduledTask<R> schedule(Callable<R> callable, long delayTicks) {
        return this.doSchedule(callable, task -> Bukkit.getScheduler().runTaskLaterAsynchronously(this.bukkitPlugin, task, delayTicks));
    }

    @Override
    public <R> ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks, RepeatPredicate<R> predicate) {
        BukkitRepeatedScheduledTask<R> task = new BukkitRepeatedScheduledTask<R>(callback, predicate);
        task.setBukkitTask(Bukkit.getScheduler().runTaskTimerAsynchronously(this.bukkitPlugin, task, delayTicks, intervalTicks));
        return task;
    }

    public BukkitAsyncScheduler(Plugin bukkitPlugin) {
        this.bukkitPlugin = bukkitPlugin;
    }
}

