/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.scheduler.folia;

import io.fairyproject.bukkit.scheduler.folia.FoliaAbstractScheduler;
import io.fairyproject.bukkit.scheduler.folia.FoliaRepeatedScheduledTask;
import io.fairyproject.bukkit.scheduler.folia.wrapper.WrapperScheduledTask;
import io.fairyproject.mc.scheduler.MCTickBasedScheduler;
import io.fairyproject.scheduler.repeat.RepeatPredicate;
import io.fairyproject.scheduler.response.TaskResponse;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class FoliaGlobalRegionScheduler
extends FoliaAbstractScheduler
implements MCTickBasedScheduler {
    private final Plugin bukkitPlugin;
    private final GlobalRegionScheduler scheduler;

    public FoliaGlobalRegionScheduler(Plugin bukkitPlugin) {
        this.bukkitPlugin = bukkitPlugin;
        this.scheduler = Bukkit.getGlobalRegionScheduler();
    }

    @Override
    public boolean isCurrentThread() {
        try {
            return Bukkit.isGlobalTickThread();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Cannot invoke isGlobalTickThread method in Bukkit", t);
        }
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> schedule(Callable<R> callable) {
        return this.doSchedule(callable, task -> this.scheduler.run(this.bukkitPlugin, task));
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> schedule(Callable<R> callable, long delayTicks) {
        return this.doSchedule(callable, task -> this.scheduler.runDelayed(this.bukkitPlugin, task, delayTicks));
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks, RepeatPredicate<R> predicate) {
        FoliaRepeatedScheduledTask<R> task = new FoliaRepeatedScheduledTask<R>(callback, predicate);
        ScheduledTask rawScheduledTask = this.scheduler.runAtFixedRate(this.bukkitPlugin, task, delayTicks, intervalTicks);
        task.setScheduledTask(WrapperScheduledTask.of(rawScheduledTask));
        return task;
    }
}

