/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.timer.impl;

import io.fairyproject.bukkit.metadata.Metadata;
import io.fairyproject.bukkit.timer.TimerBase;
import io.fairyproject.bukkit.timer.TimerList;
import io.fairyproject.metadata.MetadataKey;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.entity.Player;

public class PlayerTimer
extends TimerBase {
    public static final MetadataKey<TimerList> TIMER_METADATA_KEY = MetadataKey.create("Imanity-TimerList", TimerList.class);
    private final Player player;

    public static TimerList getTimerList(Player player) {
        return Metadata.provideForPlayer(player).getOrNull(TIMER_METADATA_KEY);
    }

    public PlayerTimer(Player player, long beginTime, long duration) {
        super(beginTime, duration, Metadata.provideForPlayer(player).getOrPut(TIMER_METADATA_KEY, TimerList::new));
        this.player = player;
    }

    public PlayerTimer(Player player, long duration) {
        this(player, System.currentTimeMillis(), duration);
    }

    @Override
    public Collection<? extends Player> getReceivers() {
        return Collections.singleton(this.player);
    }

    public Player getPlayer() {
        return this.player;
    }
}

