/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class DirectionUtil {
    public static Direction getDirection(Player player, Location location) {
        double n;
        Vector direction = player.getEyeLocation().getDirection().setY(0);
        Vector target = location.toVector().subtract(player.getLocation().toVector()).normalize().setY(0);
        for (n = Math.toDegrees(direction.angle(target)); n < 0.0; n += 360.0) {
        }
        if (n <= 45.0) {
            return Direction.UP;
        }
        if (n > 45.0 && n <= 135.0) {
            if (target.crossProduct(direction).getY() > 0.0) {
                return Direction.RIGHT;
            }
            return Direction.LEFT;
        }
        if (n > 135.0) {
            return Direction.DOWN;
        }
        return null;
    }

    public static enum Direction {
        DOWN("\u2193", "\u21e9"),
        UP("\u2191", "\u21e7"),
        RIGHT("\u2192", "\u21e8"),
        LEFT("\u2190", "\u21e6");

        private final String symbolA;
        private final String symbolB;

        private Direction(String symbolA, String symbolB) {
            this.symbolA = symbolA;
            this.symbolB = symbolB;
        }

        public String getSymbolA() {
            return this.symbolA;
        }

        public String getSymbolB() {
            return this.symbolB;
        }
    }
}

