/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util.items;

import io.fairyproject.bukkit.util.items.ArmorPart;
import io.fairyproject.bukkit.util.items.FairyItem;
import io.fairyproject.bukkit.util.items.FairyItemRef;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.MCServer;
import io.fairyproject.mc.version.MCVersion;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemSet
implements Cloneable {
    private static final int CONTENT_SIZE = 36;
    private final Slot[] slots;

    public static ItemSetBuilder builder(int slots) {
        return new ItemSetBuilder(slots);
    }

    public static ItemSetBuilder builderHotbar() {
        return new ItemSetBuilder(9);
    }

    public static ItemSetBuilder builderContents() {
        return new ItemSetBuilder(36);
    }

    public static ItemSetBuilder builderArmorContents() {
        return new ItemSetBuilder.Armor();
    }

    public static ItemSetBuilder.PlayerInventory builderPlayerInventory() {
        return new ItemSetBuilder.PlayerInventory();
    }

    public static Slot createSlotBy(Object t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Slot) {
            return (Slot)t;
        }
        if (t instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)t;
            FairyItem fairyItem = FairyItemRef.get(itemStack);
            if (fairyItem != null) {
                return new FairyItemSlot(fairyItem, itemStack.getAmount(), itemStack.getDurability());
            }
            return new ItemStackSlot(itemStack);
        }
        if (t instanceof FairyItem) {
            return new FairyItemSlot((FairyItem)t, 1, 0);
        }
        throw new UnsupportedOperationException();
    }

    public ItemSet(int slotCount) {
        this.slots = new Slot[slotCount];
    }

    public ItemSet clone() {
        ItemSet itemSet = new ItemSet(this.slots.length);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            itemSet.slots[i] = this.slots[i].clone();
        }
        return itemSet;
    }

    public int getSlotCount() {
        return this.slots.length;
    }

    public Slot getSlot(int index) {
        return this.slots[index];
    }

    public ItemStack getItem(int index, Player viewer) {
        Slot slot = this.getSlot(index);
        if (slot == null) {
            return null;
        }
        return slot.getItem(viewer);
    }

    public void setSlot(int index, Object t) {
        this.slots[index] = ItemSet.createSlotBy(t);
    }

    public ItemStack[] toItems(Player player) {
        ItemStack[] itemStacks = new ItemStack[Math.min(this.getSlotCount(), 36)];
        for (int i = 0; i < itemStacks.length; ++i) {
            Slot slot = this.getSlot(i);
            if (slot == null) continue;
            itemStacks[i] = slot.getItem(player);
        }
        return itemStacks;
    }

    public void apply(Player player) {
        ItemStack[] itemStacks = this.toItems(player);
        player.getInventory().setContents(itemStacks);
        player.updateInventory();
    }

    public Slot[] getSlots() {
        return this.slots;
    }

    public static class ItemSetBuilder {
        protected ItemSet itemSet;

        private ItemSetBuilder() {
        }

        private ItemSetBuilder(int slotCount) {
            this.itemSet = new ItemSet(slotCount);
        }

        public ItemSetBuilder set(int slot, ItemStack ... item) {
            for (int i = 0; i < item.length; ++i) {
                this.itemSet.setSlot(slot + i, item[i]);
            }
            return this;
        }

        public ItemSetBuilder set(int slot, FairyItem ... item) {
            for (int i = 0; i < item.length; ++i) {
                this.itemSet.setSlot(slot + i, item[i]);
            }
            return this;
        }

        public ItemSetBuilder set(int slot, Slot ... slots) {
            for (int i = 0; i < slots.length; ++i) {
                this.itemSet.setSlot(slot + i, slots[i]);
            }
            return this;
        }

        public ItemSetBuilder setEmpty(int slot) {
            this.itemSet.setSlot(slot, null);
            return this;
        }

        public ItemSet build() {
            return this.itemSet;
        }

        public static class PlayerInventory
        extends ItemSetBuilder {
            private PlayerInventory() {
                this.itemSet = new io.fairyproject.bukkit.util.items.ItemSet$PlayerInventory();
            }

            public PlayerInventory set(ArmorPart part, ItemStack itemStack) {
                return this.set(36 + part.getSlot(), itemStack);
            }

            public PlayerInventory set(ArmorPart part, FairyItem fairyItem) {
                return this.set(36 + part.getSlot(), fairyItem);
            }

            @Override
            public PlayerInventory set(int slot, ItemStack ... item) {
                return (PlayerInventory)super.set(slot, item);
            }

            @Override
            public PlayerInventory set(int slot, FairyItem ... item) {
                return (PlayerInventory)super.set(slot, item);
            }

            @Override
            public PlayerInventory set(int slot, Slot ... slots) {
                return (PlayerInventory)super.set(slot, slots);
            }

            @Override
            public PlayerInventory setEmpty(int slot) {
                return (PlayerInventory)super.setEmpty(slot);
            }

            @Override
            public io.fairyproject.bukkit.util.items.ItemSet$PlayerInventory build() {
                return (io.fairyproject.bukkit.util.items.ItemSet$PlayerInventory)super.build();
            }
        }

        public static class Armor
        extends ItemSetBuilder {
            private Armor() {
                this.itemSet = new Armors();
            }

            public void set(ArmorPart part, ItemStack itemStack) {
                this.set(part.getSlot(), itemStack);
            }

            public void set(ArmorPart part, FairyItem fairyItem) {
                this.set(part.getSlot(), fairyItem);
            }

            @Override
            public Armors build() {
                return (Armors)super.build();
            }
        }
    }

    public static interface Slot
    extends Cloneable {
        public ItemStack getItem(Player var1);

        public ItemStack getItem(MCPlayer var1);

        public Slot clone();
    }

    public static class FairyItemSlot
    implements Slot {
        private final FairyItem fairyItem;
        private final int amount;
        private final int durability;

        public FairyItemSlot(FairyItem fairyItem, int amount, int durability) {
            this.fairyItem = fairyItem;
            this.amount = amount;
            this.durability = durability;
        }

        @Override
        public ItemStack getItem(Player player) {
            return this.fairyItem.provide(player).amount(this.amount).durability(this.durability).build();
        }

        @Override
        public ItemStack getItem(MCPlayer player) {
            return this.fairyItem.provide(player).amount(this.amount).durability(this.durability).build();
        }

        @Override
        public Slot clone() {
            return new FairyItemSlot(this.fairyItem, this.amount, this.durability);
        }

        public FairyItem getFairyItem() {
            return this.fairyItem;
        }

        public int getAmount() {
            return this.amount;
        }

        public int getDurability() {
            return this.durability;
        }
    }

    public static class ItemStackSlot
    implements Slot {
        private final ItemStack itemStack;

        public ItemStackSlot(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        @Override
        public ItemStack getItem(Player player) {
            return this.itemStack;
        }

        @Override
        public ItemStack getItem(MCPlayer player) {
            return this.itemStack;
        }

        @Override
        public Slot clone() {
            return new ItemStackSlot(this.itemStack.clone());
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }

    public static class PlayerInventory
    extends ItemSet {
        private final Armors armors = new Armors();
        private Slot offhand = new SlotEmpty();

        public PlayerInventory() {
            super(36);
        }

        @Override
        public int getSlotCount() {
            return 40;
        }

        @Override
        public Slot[] getSlots() {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            slots.addAll(Arrays.asList(super.getSlots()));
            slots.addAll(Arrays.asList(this.armors.getSlots()));
            slots.add(this.offhand);
            return slots.toArray(new Slot[0]);
        }

        @Override
        public Slot getSlot(int index) {
            if (index >= 40) {
                return this.getOffhand();
            }
            if (index >= 36) {
                return this.armors.getSlot(index - 36);
            }
            return super.getSlot(index);
        }

        @Override
        public void setSlot(int index, Object t) {
            if (index >= 36 + this.armors.getSlotCount()) {
                this.setOffhand(t);
                return;
            }
            if (index >= 36) {
                this.armors.setSlot(index - 36, t);
                return;
            }
            super.setSlot(index, t);
        }

        public ItemStack getItem(ArmorPart part, Player viewer) {
            return this.armors.getItem(part.getSlot(), viewer);
        }

        public void setSlot(ArmorPart part, Object t) {
            this.armors.setSlot(part.getSlot(), t);
        }

        public Slot getOffhand() {
            return this.offhand;
        }

        public void setOffhand(Slot slot) {
            this.offhand = slot;
        }

        public void setOffhand(Object t) {
            this.offhand = ItemSet.createSlotBy(t);
        }

        @Override
        public ItemStack[] toItems(Player player) {
            ItemStack[] itemStacks = new ItemStack[Math.max(this.getSlotCount(), 41)];
            for (int i = 0; i < itemStacks.length; ++i) {
                Slot slot = this.getSlot(i);
                if (slot == null) continue;
                itemStacks[i] = this.getItem(i, player);
            }
            return itemStacks;
        }

        @Override
        public void apply(Player player) {
            ItemStack[] itemStacks = super.toItems(player);
            player.getInventory().setContents(itemStacks);
            this.armors.apply(player);
            if (this.offhand != null && MCServer.current().getVersion().isHigherOrEqual(MCVersion.of(9))) {
                player.getInventory().setItemInOffHand(this.offhand.getItem(player));
            }
        }

        @Override
        public PlayerInventory clone() {
            Slot slot;
            int i;
            PlayerInventory playerInventory = new PlayerInventory();
            for (i = 0; i < this.getSlotCount(); ++i) {
                slot = this.getSlot(i);
                if (slot == null) continue;
                playerInventory.setSlot(i, (Object)slot.clone());
            }
            for (i = 0; i < this.armors.getSlotCount(); ++i) {
                slot = this.armors.getSlot(i);
                if (slot == null) continue;
                playerInventory.setSlot(36 + i, (Object)slot.clone());
            }
            if (this.offhand != null) {
                playerInventory.setOffhand(this.offhand.clone());
            }
            return playerInventory;
        }

        public Armors getArmors() {
            return this.armors;
        }
    }

    public static class Armors
    extends ItemSet {
        public Armors() {
            super(4);
        }

        public ItemStack getItem(ArmorPart part, Player viewer) {
            return this.getItem(part.getSlot(), viewer);
        }

        public void setSlot(ArmorPart part, Object t) {
            this.setSlot(part.getSlot(), t);
        }

        @Override
        public ItemStack[] toItems(Player player) {
            ItemStack[] itemStacks = new ItemStack[Math.max(this.getSlotCount(), 4)];
            for (int i = 0; i < itemStacks.length; ++i) {
                Slot slot = this.getSlot(i);
                if (slot == null) continue;
                itemStacks[i] = this.getItem(i, player);
            }
            return itemStacks;
        }

        @Override
        public void apply(Player player) {
            ItemStack[] itemStacks = this.toItems(player);
            player.getInventory().setArmorContents(itemStacks);
            player.updateInventory();
        }

        @Override
        public Armors clone() {
            Armors armors = new Armors();
            for (int i = 0; i < this.getSlotCount(); ++i) {
                Slot slot = this.getSlot(i);
                if (slot == null) continue;
                armors.setSlot(i, (Object)slot.clone());
            }
            return armors;
        }
    }

    public static class SlotEmpty
    implements Slot {
        @Override
        public ItemStack getItem(Player player) {
            return null;
        }

        @Override
        public ItemStack getItem(MCPlayer player) {
            return null;
        }

        @Override
        public Slot clone() {
            return new SlotEmpty();
        }
    }
}

