/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util.schematic;

import io.fairyproject.bukkit.util.schematic.SchematicType;
import io.fairyproject.bukkit.util.schematic.impl.WorldEditSchematic;
import io.fairyproject.mc.util.BlockPosition;
import java.io.File;
import java.io.IOException;
import java.util.StringJoiner;
import org.bukkit.Location;
import org.bukkit.World;

public abstract class Schematic {
    private static final SchematicType TYPE;
    protected File file;
    protected BlockPosition top;
    protected BlockPosition bottom;

    public static Schematic create(File file) {
        switch (TYPE) {
            case WORLDEDIT: {
                return new WorldEditSchematic(file);
            }
        }
        throw new UnsupportedOperationException("Couldn't find SchematicType!");
    }

    public static Schematic create(File file, BlockPosition top, BlockPosition bottom) {
        switch (TYPE) {
            case WORLDEDIT: {
                return new WorldEditSchematic(file, top, bottom);
            }
        }
        throw new UnsupportedOperationException("Couldn't find SchematicType!");
    }

    public Schematic(File file) {
        this.file = file;
    }

    public Schematic(File file, BlockPosition top, BlockPosition bottom) {
        this.file = file;
        this.top = top;
        this.bottom = bottom;
    }

    public abstract void save(World var1) throws IOException;

    public abstract void paste(Location var1, int var2, int var3, int var4) throws IOException;

    public String toString() {
        return new StringJoiner(", ", Schematic.class.getSimpleName() + "[", "]").add("file=" + this.file).add("top=" + this.top).add("bottom=" + this.bottom).toString();
    }

    public File getFile() {
        return this.file;
    }

    public BlockPosition getTop() {
        return this.top;
    }

    public BlockPosition getBottom() {
        return this.bottom;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTop(BlockPosition top) {
        this.top = top;
    }

    public void setBottom(BlockPosition bottom) {
        this.bottom = bottom;
    }

    static {
        SchematicType lookupType = SchematicType.BUKKIT;
        try {
            Class.forName("com.sk89q.worldedit.EditSession");
            lookupType = SchematicType.WORLDEDIT;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        TYPE = lookupType;
    }
}

