/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util.sound;

import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SoundData {
    private Sound sound;
    private float volume;
    private float pitch;

    public SoundData(Sound sound) {
        this(sound, 1.0f, 1.0f);
    }

    public void play(Player ... players) {
        for (Player player : players) {
            player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
        }
    }

    public void play(Iterable<? extends Player> players) {
        for (Player player : players) {
            player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
        }
    }

    public void play(Location location) {
        location.getWorld().playSound(location, this.sound, this.volume, this.pitch);
    }

    public void play(Location location, Player ... players) {
        for (Player player : players) {
            player.playSound(location, this.sound, this.volume, this.pitch);
        }
    }

    public void play(Location location, Iterable<Player> players) {
        for (Player player : players) {
            player.playSound(location, this.sound, this.volume, this.pitch);
        }
    }

    public static SoundData of(Sound sound) {
        return new SoundData(sound);
    }

    public static SoundData of(Sound sound, float volume, float pitch) {
        return new SoundData(sound, volume, pitch);
    }

    public static SoundData ofVolume(Sound sound, float volume) {
        return new SoundData(sound, volume, 1.0f);
    }

    public static SoundData ofPitch(Sound sound, float pitch) {
        return new SoundData(sound, 1.0f, pitch);
    }

    public Sound getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoundData)) {
            return false;
        }
        SoundData other = (SoundData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        Sound this$sound = this.getSound();
        Sound other$sound = other.getSound();
        return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SoundData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        Sound $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        return result;
    }

    public String toString() {
        return "SoundData(sound=" + this.getSound() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ")";
    }

    public SoundData(Sound sound, float volume, float pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }
}

