/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.visibility;

import io.fairyproject.bukkit.events.player.PlayerPostJoinEvent;
import io.fairyproject.bukkit.listener.RegisterAsListener;
import io.fairyproject.bukkit.visibility.VisibilityService;
import io.fairyproject.container.Autowired;
import io.fairyproject.container.InjectableComponent;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;

@InjectableComponent
@RegisterAsListener
public class VisibilityListener
implements Listener {
    @Autowired
    private VisibilityService visibilityService;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerPostJoinEvent event) {
        this.visibilityService.update(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTabComplete(PlayerChatTabCompleteEvent event) {
        String token = event.getLastToken();
        Collection completions = event.getTabCompletions();
        completions.clear();
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (!this.visibilityService.treatAsOnline(target, event.getPlayer()) || !target.getName().toLowerCase().startsWith(token.toLowerCase())) continue;
            completions.add(target.getName());
        }
    }
}

