/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.visual;

import io.fairyproject.bukkit.visual.VisualBlock;
import io.fairyproject.bukkit.visual.VisualBlockService;
import io.fairyproject.bukkit.visual.sender.VisualBlockSender;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.libs.packetevents.event.PacketListenerAbstract;
import io.fairyproject.libs.packetevents.event.PacketReceiveEvent;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketTypeCommon;
import io.fairyproject.libs.packetevents.util.Vector3i;
import io.fairyproject.libs.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import io.fairyproject.libs.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import io.fairyproject.mc.protocol.MCProtocol;
import org.bukkit.entity.Player;

@InjectableComponent
public class VisualPacketListener
extends PacketListenerAbstract {
    private final VisualBlockService visualBlockService;

    @PostInitialize
    public void onPostInitialize() {
        MCProtocol.listen(this);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        PacketTypeCommon packetType = event.getPacketType();
        Player player = (Player)event.getPlayer();
        if (player == null) {
            return;
        }
        if (packetType == PacketType.Play.Client.PLAYER_DIGGING) {
            this.handleBlockDigging(event, player);
        } else if (packetType == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            this.handleBlockPlace(event, player);
        }
    }

    private void handleBlockPlace(PacketReceiveEvent event, Player player) {
        WrapperPlayClientPlayerBlockPlacement packet = new WrapperPlayClientPlayerBlockPlacement(event);
        Vector3i blockPosition = packet.getBlockPosition();
        if (this.visualBlockService.isVisualBlock(player, blockPosition.x, blockPosition.y, blockPosition.z)) {
            event.setCancelled(true);
        }
    }

    private void handleBlockDigging(PacketReceiveEvent event, Player player) {
        VisualBlockSender sender = this.visualBlockService.getVisualBlockSender();
        WrapperPlayClientPlayerDigging packet = new WrapperPlayClientPlayerDigging(event);
        Vector3i blockPosition = packet.getBlockPosition();
        VisualBlock visualBlock = this.visualBlockService.getVisualBlock(player, blockPosition.x, blockPosition.y, blockPosition.z);
        if (visualBlock != null) {
            event.setCancelled(true);
            sender.sendBlock(player, visualBlock);
        }
    }

    public VisualPacketListener(VisualBlockService visualBlockService) {
        this.visualBlockService = visualBlockService;
    }
}

