/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.visual.sender.impl;

import io.fairyproject.bukkit.visual.sender.VisualData;
import io.fairyproject.libs.packetevents.protocol.world.states.WrappedBlockState;
import io.fairyproject.libs.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

public class BukkitVisualData
implements VisualData {
    @Override
    public boolean isCapable() {
        try {
            Class<?> aClass = Class.forName("org.bukkit.block.data.BlockData");
            aClass.getDeclaredMethod("getAsString", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public int getId(@NotNull XMaterial material) {
        Material bukkitMaterial = material.parseMaterial();
        if (bukkitMaterial == null) {
            return 0;
        }
        BlockData blockData = Bukkit.createBlockData((Material)bukkitMaterial);
        String string = blockData.getAsString();
        WrappedBlockState wrappedBlockState = WrappedBlockState.getByString(string);
        return wrappedBlockState.getGlobalId();
    }
}

