/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.command;

import io.fairyproject.command.BaseCommandInitializer;
import io.fairyproject.command.CommandContext;
import io.fairyproject.command.CommandService;
import io.fairyproject.command.ICommand;
import io.fairyproject.command.MessageType;
import io.fairyproject.command.PresenceProvider;
import io.fairyproject.command.SubCommandType;
import io.fairyproject.command.annotation.Command;
import io.fairyproject.command.argument.ArgCompletionHolder;
import io.fairyproject.command.argument.ArgProperty;
import io.fairyproject.command.exception.ArgTransformException;
import io.fairyproject.command.util.CoreCommandUtil;
import io.fairyproject.container.Autowired;
import io.fairyproject.data.MetaStorage;
import io.fairyproject.util.entry.Entry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCommand
implements ICommand {
    @Autowired
    private static CommandService COMMAND_SERVICE;
    protected final Map<String, Set<ICommand>> subCommands = new ConcurrentHashMap<String, Set<ICommand>>();
    protected final List<ICommand> sortedCommands = new ArrayList<ICommand>();
    protected ICommand noArgCommand;
    protected Map<String, ArgCompletionHolder> tabCompletion;
    protected MetaStorage metaStorage;
    protected PresenceProvider<?> presenceProvider;
    @Nullable
    protected BaseCommand parentCommand;
    protected ArgProperty<?>[] baseArgs;
    protected String[] names;
    protected String permission;
    protected int maxParameterCount;
    protected int requireInputParameterCount;
    protected boolean displayOnPermission;
    protected String usage;
    protected int order;

    @Override
    public int order() {
        return this.order;
    }

    public String getDescription() {
        return "";
    }

    public String[] getCommandNames() {
        return this.names;
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.getClass().getDeclaredAnnotation(type);
    }

    public void onArgumentFailed(CommandContext commandContext, String source, String reason) {
        commandContext.sendMessage(MessageType.ERROR, reason);
    }

    public void onArgumentMissing(CommandContext commandContext, String usage) {
        commandContext.sendMessage(MessageType.WARN, "Usage: " + usage);
    }

    public void onAccessDenied(CommandContext commandContext) {
        commandContext.sendMessage(MessageType.ERROR, "You don't have permission to execute this command!");
    }

    public void onHelp(CommandContext commandContext) {
        ArrayList<String> messages = new ArrayList<String>();
        for (ICommand command : this.sortedCommands) {
            if (command.isDisplayOnPermission() && !command.canAccess(commandContext)) continue;
            messages.add(command.getUsage(commandContext));
        }
        commandContext.sendMessage(MessageType.INFO, messages);
    }

    public void onError(CommandContext commandContext, Throwable throwable) {
        commandContext.sendMessage(MessageType.ERROR, "Internal Exception: " + throwable.getClass().getName() + " - " + throwable.getMessage());
    }

    @Override
    public boolean canAccess(CommandContext commandContext) {
        if (this.permission == null || this.permission.isEmpty()) {
            return true;
        }
        return commandContext.hasPermission(this.permission);
    }

    protected void addSubCommand(@NotNull String[] commandNames, @NotNull ICommand subCommand) {
        for (String commandName : commandNames) {
            this.subCommands.computeIfAbsent(commandName.toLowerCase(), k -> new CopyOnWriteArraySet()).add(subCommand);
        }
        this.maxParameterCount = Math.max(subCommand.getMaxParameterCount(), this.maxParameterCount);
        this.requireInputParameterCount = Math.max(subCommand.getRequireInputParameterCount(), this.requireInputParameterCount);
    }

    public void init() {
        this.init(this.getClass().getAnnotation(Command.class));
    }

    public void init(@Nullable Command command) {
        if (command == null) {
            throw new IllegalArgumentException("Command annotation is null!");
        }
        this.init(command.value(), command.permissionNode());
    }

    public void init(String[] names, String permission) {
        new BaseCommandInitializer(this).init(names, permission);
    }

    @Override
    public void execute(CommandContext commandContext) {
        if (this.presenceProvider != null) {
            commandContext.setPresenceProvider(this.presenceProvider);
        } else {
            commandContext.setPresenceProvider(COMMAND_SERVICE.getPresenceProviderByType(commandContext.getClass()));
        }
        if (!this.canAccess(commandContext)) {
            this.onAccessDenied(commandContext);
            return;
        }
        if (!this.resolveBaseArguments(commandContext)) {
            return;
        }
        Entry<ICommand, String[]> pair = this.findSubCommand(commandContext, false);
        if (pair == null) {
            this.onHelp(commandContext);
            return;
        }
        commandContext.setArgs(pair.getValue());
        pair.getKey().execute(commandContext);
    }

    public boolean resolveBaseArguments(CommandContext commandContext) {
        if (this.baseArgs.length == 0) {
            return true;
        }
        String[] args = commandContext.getArgs();
        if (args.length < this.baseArgs.length) {
            ArgProperty<?> baseArg = this.baseArgs[args.length];
            baseArg.getMissingArgument().accept(commandContext);
            return false;
        }
        for (int i = 0; i < this.baseArgs.length; ++i) {
            Object obj;
            ArgProperty<?> baseArg = this.baseArgs[i];
            try {
                obj = this.baseArgs[i].getParameterHolder() != null ? this.baseArgs[i].getParameterHolder().transform(commandContext, args[i]) : CommandService.INSTANCE.transformParameter(commandContext, args[i], this.baseArgs[i].getType());
            }
            catch (ArgTransformException ex) {
                baseArg.getUnknownArgument().accept(commandContext, args[i], ex.getMessage());
                return false;
            }
            if (obj == null) {
                baseArg.getUnknownArgument().accept(commandContext, args[i], "ArgTransformer doesn't return result.");
                return false;
            }
            try {
                commandContext.addProperty(baseArg, baseArg.cast(obj));
                continue;
            }
            catch (Throwable throwable) {
                baseArg.getUnknownArgument().accept(commandContext, args[i], "ArgTransformer returned a type unmatched result.");
                return false;
            }
        }
        commandContext.setArgs(CoreCommandUtil.arrayFromRange(args, this.baseArgs.length, args.length - 1));
        return true;
    }

    @Override
    public List<String> completeCommand(CommandContext commandContext) {
        if (this.presenceProvider != null) {
            commandContext.setPresenceProvider(this.presenceProvider);
        } else {
            commandContext.setPresenceProvider(COMMAND_SERVICE.getPresenceProviderByType(commandContext.getClass()));
        }
        Entry<List<String>, Boolean> pair = this.completeArguments(commandContext);
        List<String> result = pair.getKey();
        if (pair.getValue().booleanValue()) {
            result = new ArrayList<String>(result);
            result.addAll(this.getCommandsForCompletion(commandContext));
        }
        return result;
    }

    private Entry<List<String>, Boolean> completeArguments(CommandContext commandContext) {
        if (commandContext.getArgs().length == 0) {
            return new Entry<List<String>, Boolean>(Collections.emptyList(), true);
        }
        List<String> base = this.completeBaseArguments(commandContext);
        if (base != null) {
            commandContext.setArgs(CoreCommandUtil.arrayFromRange(commandContext.getArgs(), this.baseArgs.length, commandContext.getArgs().length - 1));
            return new Entry<List<String>, Boolean>(base, false);
        }
        Entry<ICommand, String[]> subCommand = this.findSubCommand(commandContext, true);
        if (subCommand != null) {
            commandContext.setArgs(subCommand.getValue());
            return new Entry<List<String>, Boolean>(subCommand.getKey().completeCommand(commandContext), false);
        }
        return new Entry<List<String>, Boolean>(Collections.emptyList(), true);
    }

    public List<String> completeBaseArguments(CommandContext commandContext) {
        if (this.baseArgs.length == 0) {
            return null;
        }
        String[] args = commandContext.getArgs();
        if (args.length <= this.baseArgs.length) {
            ArgProperty<?> baseArg = this.baseArgs[args.length - 1];
            String source = args[args.length - 1];
            if (baseArg.getParameterHolder() != null) {
                return baseArg.getParameterHolder().tabComplete(commandContext, source);
            }
            return COMMAND_SERVICE.tabCompleteParameters(commandContext, source, baseArg.getType());
        }
        commandContext.setArgs(CoreCommandUtil.arrayFromRange(args, this.baseArgs.length, args.length - 1));
        return null;
    }

    public ArgCompletionHolder getTabCompletionHolder(String name) {
        if (this.tabCompletion.containsKey(name.toLowerCase())) {
            return this.tabCompletion.get(name.toLowerCase());
        }
        if (this.parentCommand != null) {
            return this.parentCommand.getTabCompletionHolder(name.toLowerCase());
        }
        return COMMAND_SERVICE.getTabCompletionHolder(name);
    }

    public List<String> getCommandsForCompletion(CommandContext commandContext) {
        String[] args = commandContext.getArgs();
        HashSet<String> commands = new HashSet<String>();
        int cmdIndex = Math.max(0, args.length - 1);
        String argString = BaseCommand.joinStringArray(args, args.length);
        for (Map.Entry<String, Set<ICommand>> entry : this.subCommands.entrySet()) {
            for (ICommand value : entry.getValue()) {
                String key = entry.getKey();
                if (!key.startsWith(argString) || !value.canAccess(commandContext)) continue;
                String[] split = key.split(" ");
                commands.add(split[cmdIndex]);
            }
        }
        return new ArrayList<String>(commands);
    }

    private Entry<ICommand, String[]> findSubCommand(CommandContext commandContext, boolean completion) {
        String[] args = commandContext.getArgs();
        PossibleSearches possibleSubCommands = this.findPossibleSubCommands(commandContext, args);
        if (possibleSubCommands == null) {
            return null;
        }
        if (possibleSubCommands.getPossibleCommands().size() == 1) {
            return new Entry<ICommand, String[]>(BaseCommand.getFirstElement(possibleSubCommands.getPossibleCommands()), possibleSubCommands.getArgs());
        }
        Optional<ICommand> optional = possibleSubCommands.getPossibleCommands().stream().filter(c -> this.isProbableMatch((ICommand)c, args, completion)).min((c1, c2) -> {
            int b;
            int a = c1.getMaxParameterCount();
            if (a == (b = c2.getMaxParameterCount())) {
                return 0;
            }
            return a < b ? 1 : -1;
        });
        if (optional.isPresent()) {
            return new Entry<ICommand, String[]>(optional.get(), possibleSubCommands.getArgs());
        }
        return null;
    }

    private boolean isProbableMatch(ICommand c, String[] args, boolean completion) {
        int required = c.getRequireInputParameterCount();
        return args.length <= c.getMaxParameterCount() && (completion || args.length >= required);
    }

    private PossibleSearches findPossibleSubCommands(CommandContext commandContext, String[] args) {
        if (args.length == 0) {
            if (this.noArgCommand != null) {
                return new PossibleSearches(Collections.singleton(this.noArgCommand), args, "");
            }
        } else {
            for (int i = args.length; i >= 0; --i) {
                String subcommand = BaseCommand.joinStringArray(args, i);
                Set<ICommand> commands = this.subCommands.getOrDefault(subcommand, Collections.emptySet());
                if (commands.isEmpty()) continue;
                return new PossibleSearches(commands, CoreCommandUtil.arrayFromRange(args, i, args.length - 1), subcommand);
            }
        }
        if (this.noArgCommand != null) {
            return new PossibleSearches(Collections.singleton(this.noArgCommand), args, "");
        }
        return null;
    }

    @NotNull
    private static String joinStringArray(String[] args, int i) {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < i; ++j) {
            builder.append(args[j]);
            if (j == i - 1) continue;
            builder.append(" ");
        }
        return builder.toString().toLowerCase();
    }

    private static <T> T getFirstElement(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public String getUsage(CommandContext commandContext) {
        String baseCommand = (this.parentCommand != null ? this.parentCommand.getUsage(commandContext) : commandContext.getCommandPrefix()) + this.getCommandNames()[0];
        return this.usage.replaceAll("<baseCommand>", baseCommand);
    }

    @Override
    public SubCommandType getSubCommandType() {
        return SubCommandType.CLASS_LEVEL;
    }

    public MetaStorage getMetaStorage() {
        return this.metaStorage;
    }

    public ArgProperty<?>[] getBaseArgs() {
        return this.baseArgs;
    }

    @Override
    public int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    @Override
    public int getRequireInputParameterCount() {
        return this.requireInputParameterCount;
    }

    @Override
    public boolean isDisplayOnPermission() {
        return this.displayOnPermission;
    }

    private static class PossibleSearches {
        private final Set<ICommand> possibleCommands;
        private final String[] args;
        private final String subCommand;

        public PossibleSearches(Set<ICommand> possibleCommands, String[] args, String subCommand) {
            this.possibleCommands = possibleCommands;
            this.args = args;
            this.subCommand = subCommand;
        }

        public Set<ICommand> getPossibleCommands() {
            return this.possibleCommands;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String getSubCommand() {
            return this.subCommand;
        }
    }
}

