/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.command;

import io.fairyproject.command.MessageType;
import io.fairyproject.command.PresenceProvider;
import io.fairyproject.command.argument.ArgProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CommandContext {
    private final Map<ArgProperty<?>, Object> properties;
    private final String[] originalArgs;
    private String[] args;
    private PresenceProvider presenceProvider;

    public CommandContext(String[] args) {
        this.args = args;
        this.originalArgs = args;
        this.properties = new HashMap();
    }

    public String name() {
        return "default-executor";
    }

    public <T> void addProperty(ArgProperty<T> key, Object value) {
        this.properties.put(key, value);
    }

    public boolean hasProperty(ArgProperty<?> key) {
        return this.properties.containsKey(key);
    }

    public <T> T getProperty(ArgProperty<T> property) {
        return property.getType().cast(this.properties.getOrDefault(property, null));
    }

    public String getCommandPrefix() {
        return "/";
    }

    public <T extends CommandContext> T as(Class<T> type) {
        if (!type.isInstance(this)) {
            throw new UnsupportedOperationException();
        }
        return (T)((CommandContext)type.cast(this));
    }

    public final void sendMessage(MessageType messageType, Collection<String> messages) {
        this.presenceProvider.sendMessage(this, messageType, messages.toArray(new String[0]));
    }

    public final void sendMessage(MessageType messageType, String ... messages) {
        this.presenceProvider.sendMessage(this, messageType, messages);
    }

    public boolean hasPermission(String permission) {
        return true;
    }

    public Map<ArgProperty<?>, Object> getProperties() {
        return this.properties;
    }

    public String[] getOriginalArgs() {
        return this.originalArgs;
    }

    public String[] getArgs() {
        return this.args;
    }

    public PresenceProvider getPresenceProvider() {
        return this.presenceProvider;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setPresenceProvider(PresenceProvider presenceProvider) {
        this.presenceProvider = presenceProvider;
    }
}

