/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.command;

import io.fairyproject.command.BaseCommand;
import io.fairyproject.command.CommandContext;
import io.fairyproject.command.CommandService;
import io.fairyproject.command.ICommand;
import io.fairyproject.command.MessageType;
import io.fairyproject.command.PresenceProvider;
import io.fairyproject.command.SubCommandType;
import io.fairyproject.command.annotation.Arg;
import io.fairyproject.command.annotation.Command;
import io.fairyproject.command.annotation.CommandPresence;
import io.fairyproject.command.annotation.Completion;
import io.fairyproject.command.annotation.Order;
import io.fairyproject.command.annotation.Usage;
import io.fairyproject.command.annotation.Wildcard;
import io.fairyproject.command.argument.ArgCompletionHolder;
import io.fairyproject.command.argument.ArgMeta;
import io.fairyproject.command.exception.ArgTransformException;
import io.fairyproject.command.util.CoreCommandUtil;
import io.fairyproject.container.Autowired;
import io.fairyproject.util.RV;
import io.fairyproject.util.Stacktrace;
import io.fairyproject.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommandMeta
implements ICommand {
    @Autowired
    private static CommandService COMMAND_SERVICE;
    private final String[] names;
    private final String permission;
    private final String usage;
    private final List<ArgMeta> arguments = new ArrayList<ArgMeta>();
    private final BaseCommand baseCommand;
    private final Class<?> contextClass;
    private final Method method;
    private final PresenceProvider presenceProvider;
    private final boolean displayOnPermission;
    private final int order;
    private int requireInputParameterCount;
    private int maxParameterCount;

    public CommandMeta(Command annotation, Method method, BaseCommand command) throws IllegalAccessException {
        this.baseCommand = command;
        this.method = method;
        Class<?>[] parametersClasses = method.getParameterTypes();
        this.contextClass = parametersClasses[0];
        int skippedCount = 0;
        for (int parameterIndex = 1; parameterIndex < parametersClasses.length; ++parameterIndex) {
            ArgMeta argMeta;
            String usage;
            Parameter parameter = method.getParameters()[parameterIndex];
            Arg argAnnotation = parameter.getAnnotation(Arg.class);
            String[] tabCompletion = new String[]{};
            Completion completionAnnotation = parameter.getAnnotation(Completion.class);
            if (completionAnnotation != null) {
                tabCompletion = completionAnnotation.value();
            }
            boolean wildcard = parameter.getAnnotation(Wildcard.class) != null;
            Usage usageAnnotation = parameter.getAnnotation(Usage.class);
            String string = usage = usageAnnotation != null ? usageAnnotation.value() : null;
            if (argAnnotation != null) {
                if (wildcard && parameterIndex != parametersClasses.length - 1) {
                    throw new IllegalArgumentException("Argument " + argAnnotation.value() + " is wildcard while not being last arg.");
                }
                String name = argAnnotation.value();
                if (name.isEmpty()) {
                    name = parameter.getName();
                }
                if (usage == null) {
                    usage = (!argAnnotation.defaultValue().isEmpty() ? "[" : "<") + name + (!argAnnotation.defaultValue().isEmpty() ? "]" : ">");
                }
                argMeta = new ArgMeta(name, wildcard, argAnnotation.defaultValue(), usage, tabCompletion, parameter.getType());
            } else {
                if (usage == null) {
                    usage = "<" + parameter.getName() + ">";
                }
                argMeta = new ArgMeta(parameter.getName(), wildcard, "", usage, tabCompletion, parameter.getType());
            }
            this.arguments.add(argMeta);
            if (argMeta.getDefaultValue() == null || argMeta.getDefaultValue().isEmpty()) {
                this.requireInputParameterCount += skippedCount + 1;
                skippedCount = 0;
            } else {
                ++skippedCount;
            }
            if (argMeta.isWildcard()) {
                this.maxParameterCount = Integer.MAX_VALUE;
                continue;
            }
            ++this.maxParameterCount;
        }
        Usage usageAnnotation = method.getAnnotation(Usage.class);
        boolean bl = this.displayOnPermission = usageAnnotation != null && usageAnnotation.displayOnPermission();
        if (usageAnnotation != null && usageAnnotation.overwrite()) {
            this.usage = usageAnnotation.value();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.arguments.size(); ++i) {
                stringBuilder.append("<").append(i).append(">");
                if (i + 1 >= this.arguments.size()) continue;
                stringBuilder.append(" ");
            }
            String usage = "<baseCommand> " + stringBuilder;
            if (usageAnnotation != null) {
                usage = usage + " - " + usageAnnotation.value();
            }
            this.usage = usage;
        }
        PresenceProvider<?> presenceProviderMethod = null;
        CommandPresence annotationMethod = method.getAnnotation(CommandPresence.class);
        if (annotationMethod != null) {
            presenceProviderMethod = COMMAND_SERVICE.getPresenceProviderByAnnotation(annotationMethod);
        } else if (command.presenceProvider != null) {
            presenceProviderMethod = command.presenceProvider;
        }
        if (presenceProviderMethod == null) {
            presenceProviderMethod = COMMAND_SERVICE.getPresenceProviderByType(parametersClasses[0]);
        }
        if (presenceProviderMethod == null) {
            throw new IllegalArgumentException("The method " + method + " with first parameters " + parametersClasses[0].getSimpleName() + " doesn't have match presence provider!");
        }
        if (!parametersClasses[0].isAssignableFrom(presenceProviderMethod.type())) {
            throw new IllegalArgumentException("The method " + method + " with first parameters " + parametersClasses[0].getSimpleName() + " doesn't match to " + presenceProviderMethod.getClass().getSimpleName() + " (requires type: " + presenceProviderMethod.type().getSimpleName() + ")");
        }
        this.names = annotation.value();
        this.permission = annotation.permissionNode();
        this.presenceProvider = presenceProviderMethod;
        Order order = method.getAnnotation(Order.class);
        this.order = order != null ? order.value() : 0;
    }

    @Override
    public int order() {
        return this.order;
    }

    public int getParameterCount() {
        return this.arguments.size();
    }

    public String getName() {
        return this.names[0];
    }

    @Override
    public boolean canAccess(CommandContext commandContext) {
        if (this.permission == null || this.permission.length() == 0) {
            return true;
        }
        return commandContext.hasPermission(this.permission);
    }

    @Override
    public String getUsage(CommandContext commandContext) {
        return this.getUsage(commandContext, this.getName());
    }

    public String getUsage(CommandContext commandContext, String aliasUsed) {
        ArrayList<RV> replaceValues = new ArrayList<RV>();
        String baseCommandUsage = this.baseCommand.getUsage(commandContext);
        if (aliasUsed.equals("#")) {
            replaceValues.add(RV.o("<baseCommand>", baseCommandUsage.substring(0, baseCommandUsage.length() - 1)));
        } else {
            replaceValues.add(RV.o("<baseCommand>", baseCommandUsage + aliasUsed.toLowerCase()));
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            ArgMeta argMeta = this.arguments.get(i);
            replaceValues.add(RV.o("<" + i + ">", argMeta.getUsage()));
        }
        return StringUtil.replace(this.usage, replaceValues.toArray(new RV[0]));
    }

    @Override
    public SubCommandType getSubCommandType() {
        return SubCommandType.METHOD_LEVEL;
    }

    @Override
    public int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    @Override
    public void execute(CommandContext commandContext) {
        if (this.presenceProvider != null) {
            commandContext.setPresenceProvider(this.presenceProvider);
        }
        String[] arguments = commandContext.getArgs();
        if (!this.contextClass.isAssignableFrom(commandContext.getClass())) {
            commandContext.sendMessage(MessageType.ERROR, "This command cannot be executed by " + commandContext.name());
            return;
        }
        if (!this.canAccess(commandContext)) {
            this.baseCommand.onAccessDenied(commandContext);
            return;
        }
        ArrayList<Object> transformedParameters = new ArrayList<Object>();
        transformedParameters.add(commandContext);
        for (int i = 0; i < this.getArguments().size(); ++i) {
            Object result;
            ArgMeta parameter = this.getArguments().get(i);
            String passedParameter = (i < arguments.length ? arguments[i] : parameter.getDefaultValue()).trim();
            if (i >= arguments.length && (parameter.getDefaultValue() == null || parameter.getDefaultValue().isEmpty())) {
                commandContext.sendMessage(MessageType.INFO, this.getUsage(commandContext));
                return;
            }
            if (parameter.isWildcard() && !passedParameter.trim().equals(parameter.getDefaultValue().trim())) {
                passedParameter = CommandMeta.toString(arguments, i);
            }
            try {
                result = CommandService.INSTANCE.transformParameter(commandContext, passedParameter, parameter.getParameterClass());
            }
            catch (ArgTransformException ex) {
                this.baseCommand.onArgumentFailed(commandContext, passedParameter, ex.getMessage());
                return;
            }
            if (result == null) {
                commandContext.sendMessage(MessageType.INFO, this.getUsage(commandContext));
                return;
            }
            transformedParameters.add(result);
            if (parameter.isWildcard()) break;
        }
        try {
            this.method.invoke((Object)this.baseCommand, transformedParameters.toArray());
        }
        catch (Throwable e) {
            commandContext.sendMessage(MessageType.ERROR, "Exception thrown: " + e.getMessage());
            Stacktrace.print(e);
        }
    }

    @Override
    public List<String> completeCommand(CommandContext commandContext) {
        String[] args = commandContext.getArgs();
        if (!this.canAccess(commandContext) || args.length == 0 || this.getParameterCount() == 0) {
            return Collections.emptyList();
        }
        if (!this.arguments.get(this.arguments.size() - 1).isWildcard() && args.length > this.getParameterCount()) {
            return Collections.emptyList();
        }
        ArgMeta argMeta = this.arguments.get(args.length - 1);
        if (argMeta.getTabCompletion().length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (String completion : argMeta.getTabCompletion()) {
                if (completion.startsWith("@")) {
                    ArgCompletionHolder completionHolder = this.baseCommand.getTabCompletionHolder(completion.substring(1));
                    if (completionHolder == null) continue;
                    list.addAll(completionHolder.apply(commandContext));
                    continue;
                }
                list.add(completion);
            }
            return CoreCommandUtil.filterTabComplete(args[args.length - 1], list);
        }
        List<String> tabCompletes = COMMAND_SERVICE.tabCompleteParameters(commandContext, args[args.length - 1], argMeta.getParameterClass());
        return CoreCommandUtil.filterTabComplete(args[args.length - 1], tabCompletes);
    }

    public static String toString(String[] args, int start) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int arg = start; arg < args.length; ++arg) {
            stringBuilder.append(args[arg]).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public String[] getNames() {
        return this.names;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getUsage() {
        return this.usage;
    }

    public List<ArgMeta> getArguments() {
        return this.arguments;
    }

    public BaseCommand getBaseCommand() {
        return this.baseCommand;
    }

    public Class<?> getContextClass() {
        return this.contextClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public PresenceProvider getPresenceProvider() {
        return this.presenceProvider;
    }

    @Override
    public boolean isDisplayOnPermission() {
        return this.displayOnPermission;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public int getRequireInputParameterCount() {
        return this.requireInputParameterCount;
    }
}

