/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.command.parameter.impl;

import io.fairyproject.command.CommandContext;
import io.fairyproject.command.parameter.ArgTransformer;
import io.fairyproject.container.object.Obj;

@Obj
public class DoubleArgTransformer
implements ArgTransformer<Double> {
    @Override
    public Class[] type() {
        return new Class[]{Double.class, Double.TYPE};
    }

    @Override
    public Double transform(CommandContext event, String source) {
        if (source.toLowerCase().contains("e")) {
            return (Double)this.fail(source + " is not a valid number.");
        }
        try {
            double parsed = Double.parseDouble(source);
            if (Double.isNaN(parsed) || !Double.isFinite(parsed)) {
                return (Double)this.fail(source + " is not a valid number.");
            }
            return parsed;
        }
        catch (NumberFormatException exception) {
            return (Double)this.fail(source + " is not a valid number.");
        }
    }
}

