/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.config;

import io.fairyproject.config.Comments;
import io.fairyproject.config.ConfigurationSource;
import io.fairyproject.config.ConfigurationStoreException;
import io.fairyproject.config.FieldMapper;
import io.fairyproject.config.filter.FieldFilter;
import io.fairyproject.config.filter.FieldFilters;
import io.fairyproject.config.format.FieldNameFormatter;
import io.fairyproject.config.format.FieldNameFormatters;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class Configuration<C extends Configuration<C>> {
    protected final Comments comments;
    private final Properties props;

    protected Configuration(Properties properties) {
        this.props = Objects.requireNonNull(properties);
        this.comments = Comments.ofClass(this.getClass(), properties);
    }

    public final Map<String, Object> loadEntries() throws IOException {
        return this.getSource().loadConfiguration(this.getThis());
    }

    public final void save() {
        try {
            this.preSave();
            FieldMapper.MappingInfo mappingInfo = FieldMapper.MappingInfo.from(this);
            Map<String, Object> map = FieldMapper.instanceToMap(this, mappingInfo);
            this.getSource().saveConfiguration(this.getThis(), map);
        }
        catch (IOException e) {
            throw new ConfigurationStoreException(e);
        }
    }

    public final void load() {
        try {
            Map<String, Object> map = this.loadEntries();
            FieldMapper.MappingInfo mappingInfo = FieldMapper.MappingInfo.from(this);
            FieldMapper.instanceFromMap(this, map, mappingInfo);
            this.postLoad();
        }
        catch (IOException e) {
            throw new ConfigurationStoreException(e);
        }
    }

    protected abstract ConfigurationSource<C> getSource();

    protected abstract C getThis();

    protected void preSave() {
    }

    protected void postLoad() {
    }

    Properties getProperties() {
        return this.props;
    }

    protected static class Properties {
        private final FieldNameFormatter formatter;
        private final FieldFilter filter;

        protected Properties(Builder<?> builder) {
            this.formatter = ((Builder)builder).formatter;
            this.filter = ((Builder)builder).filter;
        }

        static Builder<?> builder() {
            return new Builder(){

                protected Builder<?> getThis() {
                    return this;
                }
            };
        }

        public final FieldNameFormatter getFormatter() {
            return this.formatter;
        }

        public final FieldFilter getFilter() {
            return this.filter;
        }

        protected static abstract class Builder<B extends Builder<B>> {
            private FieldNameFormatter formatter = FieldNameFormatters.IDENTITY;
            private FieldFilter filter = FieldFilters.DEFAULT;

            protected Builder() {
            }

            protected abstract B getThis();

            public final B setFormatter(FieldNameFormatter formatter) {
                this.formatter = Objects.requireNonNull(formatter);
                return this.getThis();
            }

            public final B addFilter(FieldFilter filter) {
                this.filter = this.filter.and((Predicate)filter);
                return this.getThis();
            }

            public Properties build() {
                return new Properties(this);
            }
        }
    }
}

