/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.config.yaml;

import io.fairyproject.config.Comments;
import io.fairyproject.config.Configuration;
import io.fairyproject.config.ConfigurationSource;
import io.fairyproject.config.ConfigurationStoreException;
import io.fairyproject.config.util.YamlCompatUtil;
import io.fairyproject.config.yaml.YamlSource;
import io.fairyproject.libs.snakeyaml.DumperOptions;
import io.fairyproject.libs.snakeyaml.constructor.BaseConstructor;
import io.fairyproject.libs.snakeyaml.representer.Representer;
import io.fairyproject.libs.snakeyaml.resolver.Resolver;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class YamlConfiguration
extends Configuration<YamlConfiguration> {
    private final YamlSource source;

    protected YamlConfiguration(Path path, YamlProperties properties) {
        super(properties);
        this.source = new YamlSource(path, properties);
    }

    protected YamlConfiguration(Path path) {
        this(path, YamlProperties.DEFAULT);
    }

    @Override
    protected final ConfigurationSource<YamlConfiguration> getSource() {
        return this.source;
    }

    @Override
    protected final YamlConfiguration getThis() {
        return this;
    }

    public final void loadAndSave() {
        try {
            this.load();
            this.save();
        }
        catch (ConfigurationStoreException e) {
            if (e.getCause() instanceof NoSuchFileException) {
                this.postLoad();
                this.save();
            }
            throw e;
        }
    }

    Comments getComments() {
        return this.comments;
    }

    public static class YamlProperties
    extends Configuration.Properties {
        public static final YamlProperties DEFAULT = YamlProperties.builder().build();
        private final List<String> prependedComments;
        private final List<String> appendedComments;
        private final BaseConstructor constructor;
        private final Representer representer;
        private final DumperOptions options;
        private final Resolver resolver;

        protected YamlProperties(Builder<?> builder) {
            super(builder);
            this.prependedComments = ((Builder)builder).prependedComments;
            this.appendedComments = ((Builder)builder).appendedComments;
            this.constructor = ((Builder)builder).constructor;
            this.representer = ((Builder)builder).representer;
            this.options = ((Builder)builder).options;
            this.resolver = ((Builder)builder).resolver;
        }

        public static Builder<?> builder() {
            return new Builder(){

                @Override
                protected Builder<?> getThis() {
                    return this;
                }
            };
        }

        public final List<String> getPrependedComments() {
            return this.prependedComments;
        }

        public final List<String> getAppendedComments() {
            return this.appendedComments;
        }

        public final BaseConstructor getConstructor() {
            return this.constructor;
        }

        public final Representer getRepresenter() {
            return this.representer;
        }

        public final DumperOptions getOptions() {
            return this.options;
        }

        public final Resolver getResolver() {
            return this.resolver;
        }

        public static abstract class Builder<B extends Builder<B>>
        extends Configuration.Properties.Builder<B> {
            private List<String> prependedComments = Collections.emptyList();
            private List<String> appendedComments = Collections.emptyList();
            private BaseConstructor constructor = YamlCompatUtil.createConstructor();
            private Representer representer = YamlCompatUtil.createRepresenter();
            private DumperOptions options = new DumperOptions();
            private Resolver resolver = new Resolver();

            protected Builder() {
                this.options.setIndent(2);
                this.options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            }

            public final B setPrependedComments(List<String> prependedComments) {
                this.prependedComments = Objects.requireNonNull(prependedComments);
                return (B)((Builder)this.getThis());
            }

            public final B setAppendedComments(List<String> appendedComments) {
                this.appendedComments = Objects.requireNonNull(appendedComments);
                return (B)((Builder)this.getThis());
            }

            public final B setConstructor(BaseConstructor constructor) {
                this.constructor = Objects.requireNonNull(constructor);
                return (B)((Builder)this.getThis());
            }

            public final B setRepresenter(Representer representer) {
                this.representer = Objects.requireNonNull(representer);
                return (B)((Builder)this.getThis());
            }

            public final B setOptions(DumperOptions options) {
                this.options = Objects.requireNonNull(options);
                return (B)((Builder)this.getThis());
            }

            public final B setResolver(Resolver resolver) {
                this.resolver = Objects.requireNonNull(resolver);
                return (B)((Builder)this.getThis());
            }

            @Override
            public YamlProperties build() {
                return new YamlProperties(this);
            }
        }
    }
}

