/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container;

import io.fairyproject.ObjectSerializer;
import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.container.collection.ContainerObjCollector;
import io.fairyproject.log.Log;
import io.fairyproject.serializer.AvoidDuplicate;
import io.fairyproject.serializer.SerializerData;
import io.fairyproject.util.ConditionUtils;
import io.fairyproject.util.exceptionally.ThrowingSupplier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InjectableComponent
public class SerializerFactory {
    private final ContainerContext context;
    private Map<Class<?>, SerializerData> serializerByValueType;
    private Map<Class<?>, SerializerData> serializerBySerializerType;

    @PreInitialize
    public void onPreInitialize() {
        this.serializerByValueType = new ConcurrentHashMap();
        this.serializerBySerializerType = new ConcurrentHashMap();
        this.context.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(ObjectSerializer.class)).withAddHandler(ContainerObjCollector.warpInstance(ObjectSerializer.class, this::registerSerializer)).withRemoveHandler(ContainerObjCollector.warpInstance(ObjectSerializer.class, this::unregisterSerializer)));
    }

    public void registerSerializer(@NotNull ObjectSerializer<?, ?> serializer) {
        boolean avoidDuplication = serializer.getClass().isAnnotationPresent(AvoidDuplicate.class);
        if (this.serializerByValueType.containsKey(serializer.inputClass())) {
            if (avoidDuplication) {
                throw new IllegalArgumentException("The Serializer for " + serializer.inputClass().getName() + " already exists!");
            }
            Log.warn("Serializer with key type " + serializer.inputClass().getName() + " already exists, it is recommended to avoid duplication.", new Object[0]);
            return;
        }
        SerializerData serializerData = new SerializerData(serializer, avoidDuplication);
        this.serializerByValueType.put(serializer.inputClass(), serializerData);
        this.serializerBySerializerType.put(serializer.getClass(), serializerData);
    }

    public boolean unregisterSerializer(@NotNull ObjectSerializer<?, ?> serializer) {
        this.serializerBySerializerType.remove(serializer.getClass());
        return this.serializerByValueType.remove(serializer.inputClass()) != null;
    }

    public boolean unregisterSerializer(@NotNull Class<?> type) {
        SerializerData serializerData = this.serializerByValueType.remove(type);
        if (serializerData != null) {
            this.serializerBySerializerType.remove(serializerData.getSerializer().getClass());
            return true;
        }
        return false;
    }

    @Nullable
    public ObjectSerializer<?, ?> findSerializer(@NotNull Class<?> type) {
        SerializerData serializerData = this.serializerByValueType.get(type);
        if (serializerData == null) {
            for (Map.Entry<Class<?>, SerializerData> entry : this.serializerByValueType.entrySet()) {
                Class<?> key = entry.getKey();
                SerializerData value = entry.getValue();
                if (!key.isAssignableFrom(type)) continue;
                this.serializerByValueType.put(type, value);
                return value.getSerializer();
            }
        }
        return serializerData != null ? serializerData.getSerializer() : null;
    }

    @NotNull
    public ObjectSerializer<?, ?> findOrCacheSerializer(@NotNull Class<?> serializerClass) {
        ConditionUtils.is(ObjectSerializer.class.isAssignableFrom(serializerClass), "Cannot findOrCacheSerializer() by a non-serializer class.");
        SerializerData serializerData = this.serializerBySerializerType.get(serializerClass);
        if (serializerData == null) {
            ObjectSerializer serializer = ThrowingSupplier.sneaky(() -> (ObjectSerializer)serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).get();
            this.registerSerializer(serializer);
            return serializer;
        }
        return serializerData.getSerializer();
    }

    public SerializerFactory(ContainerContext context) {
        this.context = context;
    }

    public ContainerContext getContext() {
        return this.context;
    }

    public Map<Class<?>, SerializerData> getSerializerByValueType() {
        return this.serializerByValueType;
    }

    public Map<Class<?>, SerializerData> getSerializerBySerializerType() {
        return this.serializerBySerializerType;
    }
}

