/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.node;

import io.fairyproject.container.ContainerLogger;
import io.fairyproject.container.binder.ContainerObjectBinder;
import io.fairyproject.container.node.ContainerNode;
import io.fairyproject.container.node.Graph;
import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.util.AsyncUtils;
import io.fairyproject.util.ConditionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerNodeImpl
implements ContainerNode {
    private final String name;
    private final ContainerObjectBinder binder;
    private final Map<Class<?>, ContainerObj> objects;
    private final Set<ContainerNode> childNodes;
    private final Graph<ContainerObj> graph;

    public ContainerNodeImpl(String name, ContainerObjectBinder binder) {
        this.name = name;
        this.binder = binder;
        this.objects = new ConcurrentHashMap(16);
        this.childNodes = ConcurrentHashMap.newKeySet();
        this.graph = new GraphImpl();
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public ContainerNode addObj(@NotNull ContainerObj obj) {
        ConditionUtils.is(!this.isResolved(), "The ContainerNode has already been resolved.");
        this.objects.put(obj.getType(), obj);
        return this;
    }

    @Override
    @Nullable
    public ContainerObj getObj(@NotNull Class<?> objectType) {
        ContainerObj obj = this.objects.get(objectType);
        if (obj != null) {
            return obj;
        }
        for (ContainerNode node : this.childNodes) {
            ContainerObj nodeObj = node.getObj(objectType);
            if (nodeObj == null) continue;
            return nodeObj;
        }
        return null;
    }

    @Override
    @NotNull
    public ContainerNode addChild(@NotNull ContainerNode node) {
        this.childNodes.add(node);
        return this;
    }

    @Override
    @NotNull
    public ContainerNode removeChild(@NotNull ContainerNode node) {
        this.childNodes.remove(node);
        return this;
    }

    @Override
    @NotNull
    public Set<ContainerNode> childs() {
        return Collections.unmodifiableSet(this.childNodes);
    }

    @Override
    @NotNull
    public Set<ContainerObj> all() {
        HashSet<ContainerObj> retVal = new HashSet<ContainerObj>(this.objects.values());
        for (ContainerNode childNode : this.childNodes) {
            retVal.addAll(childNode.all());
        }
        return retVal;
    }

    @Override
    @NotNull
    public Graph<ContainerObj> graph() {
        return this.graph;
    }

    @Override
    @NotNull
    public ContainerNode resolve() {
        if (this.isResolved()) {
            return this;
        }
        for (ContainerObj obj : this.objects.values()) {
            for (Class<?> dependClass : obj.getDependencies()) {
                if (this.binder.isBound(dependClass)) continue;
                ContainerLogger.report(this, obj, null, "Unknown dependency: " + dependClass.getName(), " ", "Maybe you forgot to register it? Make sure the dependency is marked as @InjectableComponent", "and you have the class in the classpath.");
                return this;
            }
            this.graph.add(obj);
        }
        this.graph.resolve();
        for (ContainerNode childNode : this.childNodes) {
            childNode.resolve();
        }
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.graph.isResolved();
    }

    @Override
    public CompletableFuture<?> forEachClockwiseAwait(Function<ContainerObj, CompletableFuture<?>> function) {
        ArrayList futures = new ArrayList();
        futures.add(this.graph.forEachClockwiseAwait(function));
        for (ContainerNode node : this.childNodes) {
            futures.add(node.forEachClockwiseAwait(function));
        }
        return AsyncUtils.allOf(futures);
    }

    @Override
    public CompletableFuture<?> forEachCounterClockwiseAwait(Function<ContainerObj, CompletableFuture<?>> function) {
        ArrayList futures = new ArrayList();
        for (ContainerNode node : this.childNodes) {
            futures.add(node.forEachCounterClockwiseAwait(function));
        }
        futures.add(this.graph.forEachCounterClockwiseAwait(function));
        return AsyncUtils.allOf(futures);
    }

    private class GraphImpl
    extends Graph<ContainerObj> {
        private GraphImpl() {
        }

        public ContainerObj[] depends(ContainerObj parent) {
            ArrayList<ContainerObj> retVal = new ArrayList<ContainerObj>();
            for (Class<?> type : parent.getDependencies()) {
                ContainerObj obj = ContainerNodeImpl.this.binder.getBinding(type);
                if (obj == null) {
                    throw new IllegalStateException("Unknown dependency: " + type.getName());
                }
                ContainerObj current = ContainerNodeImpl.this.getObj(obj.getType());
                if (current == null) continue;
                if (current != obj) {
                    throw new IllegalStateException("Conflict depenedency: " + type.getName());
                }
                retVal.add(obj);
            }
            return retVal.toArray(new ContainerObj[0]);
        }
    }
}

