/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.node.loader;

import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.ContainerLogger;
import io.fairyproject.container.node.ContainerNode;
import io.fairyproject.container.node.loader.collection.InstanceCollection;
import io.fairyproject.container.node.loader.collection.InstanceEntry;
import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.container.object.LifeCycle;
import io.fairyproject.container.object.provider.InstanceProvider;
import io.fairyproject.container.object.resolver.ContainerObjectFactory;
import io.fairyproject.container.object.resolver.ContainerObjectResolver;
import io.fairyproject.container.object.singleton.SingletonObjectRegistry;
import io.fairyproject.container.processor.ContainerNodeInitProcessor;
import io.fairyproject.container.processor.ContainerObjConstructProcessor;
import io.fairyproject.container.processor.ContainerObjInitProcessor;
import io.fairyproject.container.scope.InjectableScope;
import io.fairyproject.container.type.TypeDescriptor;
import io.fairyproject.util.AsyncUtils;
import io.fairyproject.util.exceptionally.ThrowingRunnable;
import io.fairyproject.util.thread.BlockingThreadAwaitQueue;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ContainerNodeLoader {
    private final ContainerContext context;
    private final ContainerNode node;
    private ContainerObjectResolver containerObjectResolver;
    private InstanceCollection collection;

    public boolean load() {
        this.containerObjectResolver = ContainerObjectResolver.create(this.context.containerObjectBinder(), new ContainerObjectFactory(){

            @Override
            public CompletableFuture<Object> createInstance(Class<?> type) throws Exception {
                return ContainerNodeLoader.this.findSingletonInstance(type);
            }

            @Override
            public CompletableFuture<Object> createInstance(TypeDescriptor typeDescriptor) throws Exception {
                return ContainerNodeLoader.this.findSingletonInstance(typeDescriptor);
            }
        }, new ContainerObjectFactory(){

            @Override
            public CompletableFuture<Object> createInstance(Class<?> type) throws Exception {
                return ContainerNodeLoader.this.findPrototypeInstance(type);
            }

            @Override
            public CompletableFuture<Object> createInstance(TypeDescriptor typeDescriptor) throws Exception {
                return ContainerNodeLoader.this.findPrototypeInstance(typeDescriptor);
            }
        });
        this.collection = InstanceCollection.create();
        BlockingThreadAwaitQueue queue = BlockingThreadAwaitQueue.create();
        this.node.resolve();
        if (!this.node.isResolved()) {
            return false;
        }
        CompletionStage completableFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.provideInstances().thenRun(this::callNodePreInitProcessors)).thenComposeAsync(this.directlyCompose(this::callPreInitProcessors), (Executor)queue)).thenRun(this::handleObjCollector)).thenComposeAsync(this.directlyCompose(this::callPostInitProcessors), (Executor)queue)).thenRun(this::callNodePostInitProcessors);
        queue.await(((CompletableFuture)completableFuture)::isDone);
        ThrowingRunnable.sneaky(((CompletableFuture)completableFuture)::get).run();
        return true;
    }

    private void callNodePreInitProcessors() {
        for (ContainerNodeInitProcessor nodeInitProcessor : this.context.nodeInitProcessors()) {
            nodeInitProcessor.processNodePreInitialization(this.node, this.containerObjectResolver);
        }
    }

    private void callNodePostInitProcessors() {
        for (ContainerNodeInitProcessor nodeInitProcessor : this.context.nodeInitProcessors()) {
            nodeInitProcessor.processNodePostInitialization(this.node, this.containerObjectResolver);
        }
    }

    private CompletableFuture<Object> findSingletonInstance(Class<?> type) {
        SingletonObjectRegistry singletonObjectRegistry = this.context.singletonObjectRegistry();
        Object instance = singletonObjectRegistry.getSingleton(type);
        if (instance == null) {
            throw new IllegalStateException("Singleton instance for " + type.getName() + " is null!");
        }
        return CompletableFuture.completedFuture(instance);
    }

    private CompletableFuture<Object> findPrototypeInstance(Class<?> type) {
        ContainerObj obj = this.context.containerObjectBinder().getBinding(type);
        if (obj == null) {
            throw new IllegalStateException("Container object for " + type.getName() + " is null!");
        }
        try {
            return this.provideInstance(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to provide instance for " + type.getName(), e);
        }
    }

    private CompletableFuture<Object> findSingletonInstance(TypeDescriptor typeDescriptor) {
        SingletonObjectRegistry singletonObjectRegistry = this.context.singletonObjectRegistry();
        Object instance = singletonObjectRegistry.getSingleton(typeDescriptor.getRawType());
        if (instance == null) {
            throw new IllegalStateException("Singleton instance for " + typeDescriptor + " is null!");
        }
        return CompletableFuture.completedFuture(instance);
    }

    private CompletableFuture<Object> findPrototypeInstance(TypeDescriptor typeDescriptor) {
        ContainerObj obj = this.context.containerObjectBinder().getBinding(typeDescriptor);
        if (obj == null) {
            throw new IllegalStateException("Container object for " + typeDescriptor + " is null!");
        }
        try {
            return this.provideInstance(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to provide instance for " + typeDescriptor, e);
        }
    }

    private CompletableFuture<?> callPreInitProcessors() {
        ArrayList futures = new ArrayList();
        ArrayList snapshot = new ArrayList();
        this.collection.forEach(snapshot::add);
        for (InstanceEntry entry : snapshot) {
            Object instance = entry.getInstance();
            ContainerObj object = entry.getContainerObject();
            if (!this.trySetLifeCycle(object, LifeCycle.PRE_INIT)) continue;
            CompletionStage chain = null;
            for (ContainerObjInitProcessor initProcessor : this.context.initProcessors()) {
                try {
                    Supplier<CompletableFuture> callback = () -> initProcessor.processPreInitialization(object, instance, this.containerObjectResolver);
                    if (chain == null) {
                        chain = callback.get();
                        continue;
                    }
                    chain = chain.thenCompose($ -> (CompletionStage)callback.get());
                }
                catch (Throwable throwable) {
                    ContainerLogger.report(this.node, object, throwable, "processing pre initialization");
                }
            }
            if (chain == null) continue;
            futures.add((CompletableFuture<?>)chain);
        }
        return AsyncUtils.allOf(futures);
    }

    private CompletableFuture<?> callPostInitProcessors() {
        ArrayList futures = new ArrayList();
        for (InstanceEntry entry : this.collection) {
            Object instance = entry.getInstance();
            ContainerObj object = entry.getContainerObject();
            if (!this.trySetLifeCycle(object, LifeCycle.POST_INIT)) continue;
            CompletionStage chain = null;
            for (ContainerObjInitProcessor initProcessor : this.context.initProcessors()) {
                try {
                    Supplier<CompletableFuture> callback = () -> initProcessor.processPostInitialization(object, instance);
                    if (chain == null) {
                        chain = callback.get();
                        continue;
                    }
                    chain = chain.thenCompose($ -> (CompletionStage)callback.get());
                }
                catch (Throwable throwable) {
                    ContainerLogger.report(this.node, object, throwable, "processing post initialization");
                }
            }
            if (chain == null) continue;
            futures.add((CompletableFuture<?>)chain);
        }
        return AsyncUtils.allOf(futures);
    }

    private CompletableFuture<?> provideInstances() {
        return this.node.forEachClockwiseAwait(obj -> {
            if (obj.isPrototypeScope()) {
                return AsyncUtils.empty();
            }
            try {
                return this.provideInstance((ContainerObj)obj);
            }
            catch (Throwable throwable) {
                ContainerLogger.report(this.node, obj, throwable, "providing instance");
                return AsyncUtils.failureOf(throwable);
            }
        });
    }

    private CompletableFuture<Object> provideInstance(ContainerObj obj) throws Exception {
        InstanceProvider instanceProvider;
        Class<?> objectType = obj.getType();
        SingletonObjectRegistry singletonObjectRegistry = this.context.singletonObjectRegistry();
        if (obj.isSingletonScope()) {
            if (!this.trySetLifeCycle(obj, LifeCycle.CONSTRUCT)) {
                return AsyncUtils.empty();
            }
            if (singletonObjectRegistry.containsSingleton(objectType)) {
                Object instance2 = singletonObjectRegistry.getSingleton(objectType);
                this.postInstanceConstruct(instance2, obj);
                return AsyncUtils.empty();
            }
        }
        if ((instanceProvider = obj.getInstanceProvider()) == null) {
            throw new IllegalStateException("Instance provider for " + objectType.getName() + " is null!");
        }
        CompletableFuture<Object[]> future = this.containerObjectResolver.resolveInstances(instanceProvider.getDependencies());
        return ((CompletableFuture)((CompletableFuture)future.thenApplyAsync(objects -> ContainerNodeLoader.createInstance(obj, objects, instanceProvider), obj.getThreadingMode().getExecutor())).thenCompose(this::callConstructProcessors)).thenApply(instance -> {
            if (obj.isSingletonScope()) {
                singletonObjectRegistry.registerSingleton(objectType, instance);
            }
            this.postInstanceConstruct(instance, obj);
            return instance;
        });
    }

    private void postInstanceConstruct(Object instance, ContainerObj obj) {
        this.collection.add(instance, obj);
    }

    @NotNull
    private static Object createInstance(ContainerObj obj, Object[] dependencies, InstanceProvider instanceProvider) {
        Object instance;
        try {
            instance = instanceProvider.provide(dependencies);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to provide instance for " + obj.getType().getName(), ex);
        }
        return instance;
    }

    private CompletableFuture<Object> callConstructProcessors(Object instance) {
        ArrayList futures = new ArrayList();
        for (ContainerObjConstructProcessor constructProcessor : this.context.constructProcessors()) {
            futures.add(constructProcessor.processConstruction(instance, this.containerObjectResolver));
        }
        return AsyncUtils.allOf(futures).thenApply($ -> instance);
    }

    private boolean trySetLifeCycle(ContainerObj obj, LifeCycle lifeCycle) {
        if (obj.getScope() != InjectableScope.SINGLETON) {
            return true;
        }
        Class<?> type = obj.getType();
        SingletonObjectRegistry singletonObjectRegistry = this.context.singletonObjectRegistry();
        LifeCycle current = singletonObjectRegistry.getSingletonLifeCycle(type);
        if (current.isAfter(lifeCycle)) {
            return false;
        }
        singletonObjectRegistry.setSingletonLifeCycle(type, lifeCycle);
        return true;
    }

    private void handleObjCollector() {
        this.node.all().forEach(obj -> this.handleThrow((ContainerObj)obj, () -> this.context.objectCollectorRegistry().addToCollectors((ContainerObj)obj)));
    }

    private <T, U> Function<T, CompletionStage<U>> directlyCompose(Supplier<CompletionStage<U>> supplier) {
        return t -> (CompletionStage)supplier.get();
    }

    private void handleThrow(ContainerObj obj, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            ContainerLogger.report(this.node, obj, throwable, "initializing");
        }
    }

    private <T> T handleThrow(ContainerObj obj, Function<ContainerObj, T> function) {
        try {
            return function.apply(obj);
        }
        catch (Throwable throwable) {
            ContainerLogger.report(this.node, obj, throwable, "initializing");
            return null;
        }
    }

    public ContainerNodeLoader(ContainerContext context, ContainerNode node) {
        this.context = context;
        this.node = node;
    }
}

