/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.node.scanner;

import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.binder.ContainerObjectBinder;
import io.fairyproject.container.node.scanner.ContainerNodeClassScanner;
import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.container.object.provider.MethodInvokeInstanceProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ContainerNodeConfigurationScanner {
    private final ContainerObjectBinder binder;
    private final Class<?> configurationClass;
    private final boolean override;
    private final ContainerNodeClassScanner scanner;
    private Object instance;

    public void load() {
        this.createConfigurationInstance();
        for (Method method : this.configurationClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(InjectableComponent.class)) continue;
            this.loadConfigurationMethod(method, this.override);
        }
    }

    private void createConfigurationInstance() {
        try {
            Constructor<?> constructor = this.configurationClass.getDeclaredConstructor(new Class[0]);
            this.instance = constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Failed to create configuration instance.", ex);
        }
    }

    private void loadConfigurationMethod(Method method, boolean override) {
        ContainerObj previous;
        MethodInvokeInstanceProvider provider = new MethodInvokeInstanceProvider(this.instance, method);
        Class<?> javaClass = provider.getType();
        ContainerObj object = this.binder.getExactBinding(javaClass);
        if (object != null) {
            if (override) {
                object.setInstanceProvider(provider);
            }
        } else {
            object = this.scanner.createObject(javaClass);
            object.setInstanceProvider(provider);
        }
        if ((previous = this.scanner.getNode().getObj(javaClass)) != null) {
            if (override) {
                return;
            }
            throw new IllegalStateException("Component already exists: " + javaClass.getName());
        }
        InjectableComponent annotation = method.getAnnotation(InjectableComponent.class);
        if (annotation != null) {
            object.setScope(annotation.scope());
        }
        this.scanner.addComponentClass(object, this.scanner.getNode());
    }

    public ContainerNodeConfigurationScanner(ContainerObjectBinder binder, Class<?> configurationClass, boolean override, ContainerNodeClassScanner scanner) {
        this.binder = binder;
        this.configurationClass = configurationClass;
        this.override = override;
        this.scanner = scanner;
    }
}

