/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.node.scanner;

import io.fairyproject.container.Register;
import io.fairyproject.container.Service;
import io.fairyproject.container.binder.ContainerObjectBinder;
import io.fairyproject.container.node.scanner.ContainerNodeClassScanner;
import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.container.object.Obj;
import io.fairyproject.container.object.provider.MethodInvokeInstanceProvider;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Method;

public class ContainerNodeLegacyScanner {
    private final ScanResult scanResult;
    private final ContainerObjectBinder binder;
    private final ContainerNodeClassScanner scanner;

    void load() {
        this.loadServiceClasses();
        this.loadObjClasses();
        this.loadRegisterMethods();
    }

    private void loadServiceClasses() {
        ClassInfoList serviceClasses = this.scanResult.getClassesWithAnnotation(Service.class);
        this.scanner.loadComponentClasses(serviceClasses, this.scanner.getNode(), obj -> {
            Class<?> aClass = obj.getType();
            Service service = aClass.getAnnotation(Service.class);
            for (Class<?> dependClass : service.depends()) {
                obj.addDependency(dependClass);
            }
        });
    }

    private void loadObjClasses() {
        ClassInfoList objClasses = this.scanResult.getClassesWithAnnotation(Obj.class);
        this.scanner.loadComponentClasses(objClasses, this.scanner.getObjNode(), $ -> {});
    }

    private void loadRegisterMethods() {
        ClassInfoList registerMethodClasses = this.scanResult.getClassesWithMethodAnnotation(Register.class);
        for (ClassInfo classInfo : registerMethodClasses) {
            for (MethodInfo methodInfo : classInfo.getDeclaredMethodInfo()) {
                this.loadRegisterMethod(methodInfo);
            }
        }
    }

    private void loadRegisterMethod(MethodInfo methodInfo) {
        if (!methodInfo.hasAnnotation(Register.class) || !methodInfo.isStatic()) {
            return;
        }
        Method method = methodInfo.loadClassAndGetMethod();
        MethodInvokeInstanceProvider instanceProvider = new MethodInvokeInstanceProvider(null, method);
        Class<?> type = instanceProvider.getType();
        ContainerObj object = this.binder.getExactBinding(type);
        if (object == null) {
            object = this.scanner.createObject(type);
            object.setInstanceProvider(instanceProvider);
        }
        this.scanner.addComponentClass(object, this.scanner.getNode());
    }

    public ContainerNodeLegacyScanner(ScanResult scanResult, ContainerObjectBinder binder, ContainerNodeClassScanner scanner) {
        this.scanResult = scanResult;
        this.binder = binder;
        this.scanner = scanner;
    }
}

