/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.object.provider;

import io.fairyproject.container.object.provider.InstanceProvider;
import io.fairyproject.container.type.TypeDescriptor;
import io.fairyproject.container.util.GenericTypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.jetbrains.annotations.NotNull;

public class MethodInvokeInstanceProvider
implements InstanceProvider {
    private final Object instance;
    private final Method method;
    private final TypeDescriptor[] parameterTypeDescriptors;

    public MethodInvokeInstanceProvider(Object instance, Method method) {
        this.instance = instance;
        this.method = method;
        Parameter[] parameters = this.method.getParameters();
        this.parameterTypeDescriptors = new TypeDescriptor[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.parameterTypeDescriptors[i] = GenericTypeUtils.getTypeDescriptorFromParameter(parameters[i]);
        }
    }

    @Override
    public Class<?> getType() {
        return this.method.getReturnType();
    }

    @Override
    public Class<?>[] getDependencies() {
        return this.method.getParameterTypes();
    }

    @Override
    @NotNull
    public Object provide(Object[] dependencies) throws Exception {
        return this.method.invoke(this.instance, dependencies);
    }

    public TypeDescriptor[] getParameterTypeDescriptors() {
        return this.parameterTypeDescriptors;
    }
}

