/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.data;

import io.fairyproject.data.impl.MetaKeyImpl;
import io.fairyproject.data.impl.collection.MetaListKey;
import io.fairyproject.data.impl.collection.MetaMapKey;
import io.fairyproject.data.impl.collection.MetaSetKey;
import io.fairyproject.util.TypeLiteral;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;

public interface MetaKey<T> {
    @ApiStatus.Internal
    public static final AtomicInteger ID_COUNTER = new AtomicInteger(0);

    public int getId();

    public String getName();

    public TypeLiteral<T> getType();

    default public T cast(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Reference) {
            Object obj = ((Reference)value).get();
            if (obj == null) {
                return null;
            }
            return obj;
        }
        return (T)value;
    }

    public static int getCurrentCapacity() {
        return ID_COUNTER.get() + 1;
    }

    public static <T> MetaKey<T> create(String name, Class<T> type) {
        return new MetaKeyImpl<T>(name, new TypeLiteral<T>(type, new TypeLiteral[0]));
    }

    public static MetaKey<Boolean> createBoolean(String name) {
        return MetaKey.create(name, Boolean.class);
    }

    public static MetaKey<Integer> createInt(String name) {
        return MetaKey.create(name, Integer.class);
    }

    public static MetaKey<Long> createLong(String name) {
        return MetaKey.create(name, Long.class);
    }

    public static MetaKey<Float> createFloat(String name) {
        return MetaKey.create(name, Float.class);
    }

    public static MetaKey<Double> createDouble(String name) {
        return MetaKey.create(name, Double.class);
    }

    public static MetaKey<String> createString(String name) {
        return MetaKey.create(name, String.class);
    }

    public static MetaKey<Byte> createByte(String name) {
        return MetaKey.create(name, Byte.class);
    }

    public static MetaKey<Short> createShort(String name) {
        return MetaKey.create(name, Short.class);
    }

    public static <T> MetaKey<T> create(String name, TypeLiteral<T> type) {
        return new MetaKeyImpl<T>(name, type);
    }

    public static <T> MetaListKey<T> createList(String name, Class<T> type) {
        return new MetaListKey(name, new TypeLiteral<List<T>>(){});
    }

    public static <T> MetaListKey<T> createList(String name, TypeLiteral<List<T>> type) {
        return new MetaListKey(name, type);
    }

    public static <T> MetaSetKey<T> createSet(String name, Class<T> type) {
        return new MetaSetKey(name, new TypeLiteral<Set<T>>(){});
    }

    public static <T> MetaSetKey<T> createSet(String name, TypeLiteral<Set<T>> type) {
        return new MetaSetKey(name, type);
    }

    public static <K, V> MetaMapKey<K, V> createMap(String name, Class<K> keyType, Class<V> valueType) {
        return new MetaMapKey(name, new TypeLiteral<Map<K, V>>(){});
    }

    public static <K, V> MetaMapKey<K, V> createMap(String name, TypeLiteral<Map<K, V>> mapType) {
        return new MetaMapKey<K, V>(name, mapType);
    }
}

