/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.library;

import io.fairyproject.library.LibraryRepository;
import io.fairyproject.libs.gson.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Library {
    public static final String FAIRY_LIB_PACKAGE = "io.fairyproject.libs.";
    private static final String MAVEN_FORMAT = "%s/%s/%s/%s-%s.jar";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String versionPackage;
    private final String name;
    private final byte[] checksum;
    private final LibraryRepository repository;

    public Library(String groupId, String artifactId, String version, String checksum) {
        this(groupId, artifactId, version, version, checksum);
    }

    public Library(String groupId, String artifactId, String version, String checksum, LibraryRepository repository) {
        this(groupId, artifactId, version, version, checksum, repository);
    }

    public Library(String groupId, String artifactId, String versionPackage, String version, String checksum) {
        this(groupId, artifactId, version, versionPackage, checksum, null);
    }

    public Library(String groupId, String artifactId, String versionPackage, String version, String checksum, LibraryRepository repository) {
        this.groupId = Library.rewriteEscaping(groupId);
        this.artifactId = Library.rewriteEscaping(artifactId);
        this.name = Library.rewriteEscaping(artifactId);
        this.version = version;
        this.versionPackage = versionPackage == null ? version : versionPackage;
        this.checksum = (byte[])(checksum != null && !checksum.isEmpty() ? Base64.getDecoder().decode(checksum) : null);
        this.repository = repository != null ? repository : LibraryRepository.MAVEN_CENTRAL;
    }

    public URL getUrl(LibraryRepository repository) throws MalformedURLException {
        String repo = repository.getUrl();
        if (!repo.endsWith("/")) {
            repo = repo + "/";
        }
        repo = repo + MAVEN_FORMAT;
        String url = String.format(repo, this.groupId.replace(".", "/"), this.artifactId, this.versionPackage, this.artifactId, this.version);
        return new URL(url);
    }

    private static String rewriteEscaping(String s) {
        return s.replace("{}", ".");
    }

    public String getFileName() {
        return this.name.toLowerCase().replace('_', '-') + "-" + this.version;
    }

    public String toString() {
        return this.name;
    }

    public static Library fromJsonObject(JsonObject jsonObject) {
        String version;
        String artifactId;
        String groupId;
        if (jsonObject.has("dependency")) {
            String dependency = jsonObject.get("dependency").getAsString();
            String[] split = dependency.split(":");
            groupId = split[0];
            artifactId = split[1];
            version = split[2];
        } else {
            groupId = jsonObject.get("groupId").getAsString();
            artifactId = jsonObject.get("artifactId").getAsString();
            version = jsonObject.get("version").getAsString();
        }
        LibraryRepository libraryRepository = null;
        if (jsonObject.has("repository")) {
            String repository = jsonObject.get("repository").getAsString();
            libraryRepository = repository.equals("#mavenCentral") ? LibraryRepository.MAVEN_CENTRAL : new LibraryRepository(repository);
        }
        String checksum = null;
        if (jsonObject.has("checksum")) {
            checksum = jsonObject.get("checksum").getAsString();
        }
        return new Library(groupId, artifactId, null, version, checksum, libraryRepository);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionPackage() {
        return this.versionPackage;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public LibraryRepository getRepository() {
        return this.repository;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Library)) {
            return false;
        }
        Library other = (Library)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPackage = this.getVersionPackage();
        String other$versionPackage = other.getVersionPackage();
        if (this$versionPackage == null ? other$versionPackage != null : !this$versionPackage.equals(other$versionPackage)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.equals(this.getChecksum(), other.getChecksum())) {
            return false;
        }
        LibraryRepository this$repository = this.getRepository();
        LibraryRepository other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Library;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPackage = this.getVersionPackage();
        result = result * 59 + ($versionPackage == null ? 43 : $versionPackage.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getChecksum());
        LibraryRepository $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String version;
        private String versionPackaging;
        private String checksum;
        private LibraryRepository repository = LibraryRepository.MAVEN_CENTRAL;

        public Builder gradle(@NotNull String dependency) {
            String[] split = dependency.split(":");
            if (split.length != 3) {
                throw new IllegalArgumentException("Cannot parse gradle dependency tag.");
            }
            this.groupId(split[0]);
            this.artifactId(split[1]);
            this.version(split[2]);
            return this;
        }

        public Builder groupId(@NotNull String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifactId(@NotNull String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder version(@NotNull String version) {
            this.version = version;
            this.versionPackaging = version;
            return this;
        }

        public Builder version(@NotNull String version, @NotNull String versionPackaging) {
            this.version = version;
            this.versionPackaging = versionPackaging;
            return this;
        }

        public Builder repository(@Nullable LibraryRepository repository) {
            this.repository = repository;
            return this;
        }

        public Builder repository(@NotNull String repository) {
            this.repository = new LibraryRepository(repository);
            return this;
        }

        public Builder checksum(@NotNull String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Library build() {
            assert (this.groupId != null);
            assert (this.artifactId != null);
            assert (this.version != null);
            assert (this.versionPackaging != null);
            return new Library(this.groupId, this.artifactId, this.versionPackaging, this.version, this.checksum, this.repository);
        }
    }
}

