/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.library;

import io.fairyproject.Debug;
import io.fairyproject.library.Library;
import io.fairyproject.library.LibraryHandlerImpl;
import io.fairyproject.library.relocate.Relocation;
import io.fairyproject.plugin.Plugin;
import io.fairyproject.plugin.PluginAction;
import io.fairyproject.plugin.PluginDescription;
import io.fairyproject.plugin.PluginListenerAdapter;
import io.fairyproject.util.URLClassLoaderAccess;
import java.net.URLClassLoader;
import java.util.concurrent.CompletableFuture;

public class LibraryHandlerPluginListener
implements PluginListenerAdapter {
    private final LibraryHandlerImpl libraryHandler;

    @Override
    public void onPluginPreLoaded(ClassLoader classLoader, PluginDescription description, PluginAction action, CompletableFuture<Plugin> completableFuture) {
        if (Debug.UNIT_TEST) {
            return;
        }
        for (Library library : description.getLibraries()) {
            this.libraryHandler.loadLibrary(library, true, new Relocation[0]);
        }
    }

    @Override
    public void onPluginInitial(Plugin plugin) {
        URLClassLoaderAccess classLoader = URLClassLoaderAccess.create((URLClassLoader)plugin.getPluginClassLoader());
        this.libraryHandler.addClassLoader(plugin, classLoader);
    }

    @Override
    public void onPluginDisable(Plugin plugin) {
        this.libraryHandler.getPluginClassLoaders().remove(plugin);
    }

    public LibraryHandlerPluginListener(LibraryHandlerImpl libraryHandler) {
        this.libraryHandler = libraryHandler;
    }
}

