/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.manager;

import io.fairyproject.libs.packetevents.PacketEvents;
import io.fairyproject.libs.packetevents.event.PacketListenerAbstract;
import io.fairyproject.libs.packetevents.event.PacketListenerPriority;
import io.fairyproject.libs.packetevents.event.PacketReceiveEvent;
import io.fairyproject.libs.packetevents.event.PacketSendEvent;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.ConnectionState;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.protocol.player.ClientVersion;
import io.fairyproject.libs.packetevents.protocol.player.User;
import io.fairyproject.libs.packetevents.protocol.player.UserProfile;
import io.fairyproject.libs.packetevents.util.LogManager;
import io.fairyproject.libs.packetevents.util.mappings.SynchronizedRegistriesHandler;
import io.fairyproject.libs.packetevents.wrapper.configuration.server.WrapperConfigServerRegistryData;
import io.fairyproject.libs.packetevents.wrapper.handshaking.client.WrapperHandshakingClientHandshake;
import io.fairyproject.libs.packetevents.wrapper.login.server.WrapperLoginServerLoginSuccess;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerJoinGame;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerRespawn;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InternalPacketListener
extends PacketListenerAbstract {
    public InternalPacketListener() {
        this(PacketListenerPriority.LOWEST);
    }

    public InternalPacketListener(PacketListenerPriority priority) {
        super(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPacketSend(PacketSendEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS) {
            boolean proxy;
            Object channel = event.getChannel();
            WrapperLoginServerLoginSuccess loginSuccess = new WrapperLoginServerLoginSuccess(event);
            UserProfile profile = loginSuccess.getUserProfile();
            user.getProfile().setUUID(profile.getUUID());
            user.getProfile().setName(profile.getName());
            user.getProfile().setTextureProperties(profile.getTextureProperties());
            Object object = channel;
            synchronized (object) {
                PacketEvents.getAPI().getProtocolManager().setChannel(profile.getUUID(), channel);
            }
            if (PacketEvents.getAPI().getLogManager().isDebug()) {
                PacketEvents.getAPI().getLogManager().debug("Mapped player UUID with their channel " + profile.getUUID() + " " + channel);
            }
            if ((proxy = PacketEvents.getAPI().getInjector().isProxy()) ? event.getUser().getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_2) : event.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2)) {
                user.setEncoderState(ConnectionState.CONFIGURATION);
            } else {
                user.setConnectionState(ConnectionState.PLAY);
            }
        } else if (event.getPacketType() == PacketType.Configuration.Server.REGISTRY_DATA) {
            WrapperConfigServerRegistryData packet = new WrapperConfigServerRegistryData(event);
            if (packet.getElements() != null) {
                SynchronizedRegistriesHandler.handleRegistry(user, packet, packet.getRegistryKey(), packet.getElements());
            }
            if (packet.getRegistryData() != null) {
                SynchronizedRegistriesHandler.handleLegacyRegistries(user, packet, packet.getRegistryData());
            }
        } else if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
            WrapperPlayServerJoinGame joinGame = new WrapperPlayServerJoinGame(event);
            user.setEntityId(joinGame.getEntityId());
            if (joinGame.getDimensionCodec() != null) {
                SynchronizedRegistriesHandler.handleLegacyRegistries(user, joinGame, joinGame.getDimensionCodec());
            }
            user.setDimensionType(joinGame.getDimensionType());
        } else if (event.getPacketType() == PacketType.Play.Server.RESPAWN) {
            WrapperPlayServerRespawn packet = new WrapperPlayServerRespawn(event);
            user.setDimensionType(packet.getDimensionType());
        } else if (event.getPacketType() == PacketType.Play.Server.CONFIGURATION_START) {
            user.setEncoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Configuration.Server.CONFIGURATION_END) {
            user.setEncoderState(ConnectionState.PLAY);
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            WrapperHandshakingClientHandshake packet = new WrapperHandshakingClientHandshake(event);
            ClientVersion clientVersion = packet.getClientVersion();
            ConnectionState state = packet.getNextConnectionState();
            LogManager logger = PacketEvents.getAPI().getLogManager();
            if (logger.isDebug()) {
                logger.debug("Processed handshake for " + event.getAddress() + ": " + state.name() + " / " + packet.getClientVersion().getReleaseName());
            }
            user.setClientVersion(clientVersion);
            user.setConnectionState(state);
        } else if (event.getPacketType() == PacketType.Login.Client.LOGIN_SUCCESS_ACK) {
            user.setDecoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Play.Client.CONFIGURATION_ACK) {
            user.setDecoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Configuration.Client.CONFIGURATION_END_ACK) {
            user.setDecoderState(ConnectionState.PLAY);
        }
    }
}

