/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.entity.cow;

import io.fairyproject.libs.kyori.adventure.util.Index;
import io.fairyproject.libs.packetevents.protocol.entity.cow.CowVariants;
import io.fairyproject.libs.packetevents.protocol.entity.cow.StaticCowVariant;
import io.fairyproject.libs.packetevents.protocol.mapper.CopyableEntity;
import io.fairyproject.libs.packetevents.protocol.mapper.DeepComparableEntity;
import io.fairyproject.libs.packetevents.protocol.mapper.MappedEntity;
import io.fairyproject.libs.packetevents.protocol.nbt.NBT;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTCompound;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTString;
import io.fairyproject.libs.packetevents.protocol.player.ClientVersion;
import io.fairyproject.libs.packetevents.resources.ResourceLocation;
import io.fairyproject.libs.packetevents.util.adventure.AdventureIndexUtil;
import io.fairyproject.libs.packetevents.util.mappings.TypesBuilderData;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface CowVariant
extends MappedEntity,
CopyableEntity<CowVariant>,
DeepComparableEntity {
    public ModelType getModelType();

    public ResourceLocation getAssetId();

    public static CowVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CowVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CowVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CowVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String modelTypeString = compound.getStringTagValueOrNull("model");
        ModelType modelType = modelTypeString != null ? ModelType.getByName(modelTypeString) : ModelType.NORMAL;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCowVariant(data, modelType, assetId);
    }

    public static NBT encode(CowVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("model", new NBTString(variant.getModelType().getName()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }

    public static enum ModelType {
        NORMAL("normal"),
        COLD("cold"),
        WARM("warm");

        private static final Index<String, ModelType> NAME_INDEX;
        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public static ModelType getByName(String name) {
            return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, name);
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_INDEX = Index.create(ModelType.class, ModelType::getName);
        }
    }
}

