/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.particle.data;

import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTCompound;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTFloat;
import io.fairyproject.libs.packetevents.protocol.particle.data.ParticleData;
import io.fairyproject.libs.packetevents.protocol.player.ClientVersion;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ParticlePowerData
extends ParticleData {
    private float power;

    public ParticlePowerData(float power) {
        this.power = power;
    }

    public static ParticlePowerData read(PacketWrapper<?> wrapper) {
        float power = wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_9) ? 1.0f : wrapper.readFloat();
        return new ParticlePowerData(power);
    }

    public static void write(PacketWrapper<?> wrapper, ParticlePowerData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            wrapper.writeFloat(data.power);
        }
    }

    @ApiStatus.Internal
    public static ParticlePowerData decode(NBTCompound tag, ClientVersion version) {
        float power = tag.getNumberTagValueOrDefault("power", Float.valueOf(1.0f)).floatValue();
        return new ParticlePowerData(power);
    }

    @ApiStatus.Internal
    public static void encode(ParticlePowerData data, ClientVersion version, NBTCompound tag) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_9) && data.power != 1.0f) {
            tag.setTag("power", new NBTFloat(data.power));
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float power) {
        this.power = power;
    }
}

