/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.util;

import io.fairyproject.libs.packetevents.protocol.nbt.NBT;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTByte;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTByteArray;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTCompound;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTEnd;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTInt;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTIntArray;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTList;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTLong;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTLongArray;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTNumber;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTString;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTType;
import io.fairyproject.libs.packetevents.protocol.util.CodecNameable;
import io.fairyproject.libs.packetevents.protocol.util.NbtCodec;
import io.fairyproject.libs.packetevents.util.UniqueIdUtil;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
public final class NbtCodecs {
    public static final NbtCodec<String> STRING = new NbtCodec<String>(){

        @Override
        public String decode(NBT nbt, PacketWrapper<?> wrapper) {
            return ((NBTString)nbt).getValue();
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, String value) {
            return new NBTString(value);
        }
    };
    public static final NbtCodec<List<String>> STRING_LIST = STRING.applyList();
    public static final NbtCodec<List<? extends NBT>> GENERIC_LIST = new NbtCodec<List<? extends NBT>>(){

        @Override
        public List<? extends NBT> decode(NBT nbt, PacketWrapper<?> wrapper) {
            if (nbt instanceof NBTList) {
                return ((NBTList)nbt).unwrapTags();
            }
            if (nbt instanceof NBTIntArray) {
                int[] arr = ((NBTIntArray)nbt).getValue();
                ArrayList<NBTInt> list = new ArrayList<NBTInt>(arr.length);
                for (int num : arr) {
                    list.add(new NBTInt(num));
                }
                return list;
            }
            if (nbt instanceof NBTByteArray) {
                byte[] arr = ((NBTByteArray)nbt).getValue();
                ArrayList<NBTByte> list = new ArrayList<NBTByte>(arr.length);
                for (byte num : arr) {
                    list.add(new NBTByte(num));
                }
                return list;
            }
            if (nbt instanceof NBTLongArray) {
                long[] arr = ((NBTLongArray)nbt).getValue();
                ArrayList<NBTLong> list = new ArrayList<NBTLong>(arr.length);
                for (long num : arr) {
                    list.add(new NBTLong(num));
                }
                return list;
            }
            throw new RuntimeException("Not a list: " + nbt);
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, List<? extends NBT> value) {
            if (value.isEmpty()) {
                return new NBTList<NBTEnd>(NBTType.END, 0);
            }
            NBTType<?> type = NBTList.getCommonTagType(value);
            if (type == NBTType.COMPOUND) {
                NBTList<NBTCompound> list = new NBTList<NBTCompound>(NBTType.COMPOUND, value.size());
                for (NBT nBT : value) {
                    list.addTagOrWrap(nBT);
                }
                return list;
            }
            if (type == NBTType.INT) {
                int[] arr = new int[value.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = ((NBTInt)value.get(i)).getAsInt();
                }
                return new NBTIntArray(arr);
            }
            if (type == NBTType.BYTE) {
                byte[] arr = new byte[value.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = ((NBTByte)value.get(i)).getAsByte();
                }
                return new NBTByteArray(arr);
            }
            if (type == NBTType.LONG) {
                long[] arr = new long[value.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = ((NBTLong)value.get(i)).getAsLong();
                }
                return new NBTLongArray(arr);
            }
            NBTList<? extends NBT> list = new NBTList<NBT>(type, value);
            return list;
        }
    };
    public static final NbtCodec<int[]> INT_ARRAY = new NbtCodec<int[]>(){

        @Override
        public int[] decode(NBT nbt, PacketWrapper<?> wrapper) {
            if (nbt instanceof NBTIntArray) {
                return ((NBTIntArray)nbt).getValue();
            }
            List list = (List)GENERIC_LIST.decode(nbt, wrapper);
            int[] array = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                NBT tag = (NBT)list.get(i);
                if (!(tag instanceof NBTNumber)) {
                    throw new RuntimeException("Some elements are not numbers: " + list);
                }
                array[i] = ((NBTNumber)tag).getAsInt();
            }
            return array;
        }

        @Override
        public NBT encode(PacketWrapper<?> wrapper, int[] value) {
            return new NBTIntArray(value);
        }
    };
    public static final NbtCodec<UUID> UUID = INT_ARRAY.apply(UniqueIdUtil::fromIntArray, UniqueIdUtil::toIntArray);

    private NbtCodecs() {
    }

    public static <T extends Enum<T>> NbtCodec<T> forEnum(T[] values) {
        return new NbtCodec<T>((Enum[])values){
            private final Map<String, T> map;
            final /* synthetic */ Enum[] val$values;
            {
                this.val$values = enumArray;
                this.map = new HashMap(this.val$values.length);
                for (Enum value : this.val$values) {
                    Enum existingValue = this.map.putIfAbsent(((CodecNameable)((Object)value)).getCodecName(), value);
                    if (existingValue == null) continue;
                    throw new IllegalStateException("Can't create codec for enum with duplicate names: " + existingValue);
                }
            }

            @Override
            public T decode(NBT nbt, PacketWrapper<?> wrapper) {
                String key = ((NBTString)nbt).getValue();
                Enum value = (Enum)this.map.get(key);
                if (value == null) {
                    throw new RuntimeException("Can't find " + key + " in " + this.map.keySet());
                }
                return value;
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, T value) {
                return new NBTString(((CodecNameable)value).getCodecName());
            }
        };
    }
}

