/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.world.chunk;

import io.fairyproject.libs.packetevents.protocol.stream.NetStreamInput;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;

public class NibbleArray3d {
    private final byte[] data;

    public NibbleArray3d(byte[] data) {
        this.data = data;
    }

    public NibbleArray3d(int size) {
        this(new byte[size >> 1]);
    }

    @Deprecated
    public NibbleArray3d(NetStreamInput in, int size) {
        this(in.readBytes(size));
    }

    public NibbleArray3d(PacketWrapper<?> wrapper, int size) {
        this(wrapper.readBytes(size));
    }

    public byte[] getData() {
        return this.data;
    }

    public int get(int x, int y, int z) {
        int key = y << 8 | z << 4 | x;
        int index = key >> 1;
        int part = key & 1;
        return part == 0 ? this.data[index] & 0xF : this.data[index] >> 4 & 0xF;
    }

    public void set(int x, int y, int z, int val) {
        int key = y << 8 | z << 4 | x;
        int index = key >> 1;
        int part = key & 1;
        this.data[index] = part == 0 ? (byte)(this.data[index] & 0xF0 | val & 0xF) : (byte)(this.data[index] & 0xF | (val & 0xF) << 4);
    }
}

