/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.wrapper.play.server;

import io.fairyproject.libs.packetevents.event.PacketSendEvent;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.protocol.world.states.WrappedBlockState;
import io.fairyproject.libs.packetevents.util.Vector3i;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerBlockAction
extends PacketWrapper<WrapperPlayServerBlockAction> {
    private Vector3i blockPosition;
    private int actionID;
    private int actionData;
    private int blockTypeID;

    public WrapperPlayServerBlockAction(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerBlockAction(Vector3i blockPosition, int actionID, int actionParam, int blockTypeID) {
        super(PacketType.Play.Server.BLOCK_ACTION);
        this.blockPosition = blockPosition;
        this.actionID = actionID;
        this.actionData = actionParam;
        this.blockTypeID = blockTypeID;
    }

    @Override
    public void read() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            int x = this.readInt();
            short y = this.readShort();
            int z = this.readInt();
            this.blockPosition = new Vector3i(x, y, z);
        } else {
            this.blockPosition = this.readBlockPosition();
        }
        this.actionID = this.readUnsignedByte();
        this.actionData = this.readUnsignedByte();
        this.blockTypeID = this.readVarInt();
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeInt(this.blockPosition.x);
            this.writeShort(this.blockPosition.y);
            this.writeInt(this.blockPosition.z);
        } else {
            this.writeBlockPosition(this.blockPosition);
        }
        this.writeByte(this.actionID);
        this.writeByte(this.actionData);
        this.writeVarInt(this.blockTypeID);
    }

    @Override
    public void copy(WrapperPlayServerBlockAction wrapper) {
        this.blockPosition = wrapper.blockPosition;
        this.actionID = wrapper.actionID;
        this.actionData = wrapper.actionData;
        this.blockTypeID = wrapper.blockTypeID;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public int getActionId() {
        return this.actionID;
    }

    public void setActionId(int actionID) {
        this.actionID = actionID;
    }

    public int getActionData() {
        return this.actionData;
    }

    public void setActionData(int actionData) {
        this.actionData = actionData;
    }

    public int getBlockTypeId() {
        return this.blockTypeID;
    }

    public void setBlockTypeId(int blockTypeID) {
        this.blockTypeID = blockTypeID;
    }

    public WrappedBlockState getBlockType() {
        return WrappedBlockState.getByGlobalId(this.serverVersion.toClientVersion(), this.blockTypeID);
    }

    public void setBlockType(WrappedBlockState blockType) {
        this.blockTypeID = blockType.getGlobalId();
    }
}

