/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.wrapper.play.server;

import io.fairyproject.libs.packetevents.event.PacketSendEvent;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.protocol.potion.PotionType;
import io.fairyproject.libs.packetevents.protocol.potion.PotionTypes;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerRemoveEntityEffect
extends PacketWrapper<WrapperPlayServerRemoveEntityEffect> {
    private int entityId;
    private PotionType potionType;

    public WrapperPlayServerRemoveEntityEffect(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerRemoveEntityEffect(int entityId, PotionType potionType) {
        super(PacketType.Play.Server.REMOVE_ENTITY_EFFECT);
        this.entityId = entityId;
        this.potionType = potionType;
    }

    @Override
    public void read() {
        this.entityId = this.readVarInt();
        int effectId = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18_2) ? this.readVarInt() : (int)this.readByte();
        this.potionType = PotionTypes.getById(effectId, this.serverVersion);
    }

    @Override
    public void write() {
        this.writeVarInt(this.entityId);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18_2)) {
            this.writeVarInt(this.potionType.getId(this.serverVersion.toClientVersion()));
        } else {
            this.writeByte(this.potionType.getId(this.serverVersion.toClientVersion()));
        }
    }

    @Override
    public void copy(WrapperPlayServerRemoveEntityEffect wrapper) {
        this.entityId = wrapper.entityId;
        this.potionType = wrapper.potionType;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public PotionType getPotionType() {
        return this.potionType;
    }

    public void setPotionType(PotionType potionType) {
        this.potionType = potionType;
    }
}

