/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc;

import io.fairyproject.container.Containers;
import io.fairyproject.libs.kyori.adventure.audience.Audience;
import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import io.fairyproject.libs.kyori.adventure.translation.Translator;
import io.fairyproject.mc.GameMode;
import io.fairyproject.mc.MCEntity;
import io.fairyproject.mc.MCGameProfile;
import io.fairyproject.mc.registry.player.MCPlayerRegistry;
import io.fairyproject.mc.version.MCVersion;
import io.fairyproject.metadata.CommonMetadataRegistries;
import io.fairyproject.metadata.MetadataMap;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MCPlayer
extends MCEntity,
Audience {
    @Deprecated
    public static Collection<MCPlayer> all() {
        return Companion.BRIDGE.all();
    }

    @Nullable
    public static <T> MCPlayer from(@Nullable T originalPlayer) {
        return Containers.get(MCPlayerRegistry.class).findByPlatform(originalPlayer);
    }

    @Nullable
    public static MCPlayer find(UUID uuid) {
        return Companion.BRIDGE.find(uuid);
    }

    @Override
    public UUID getUUID();

    public String getName();

    public InetAddress getAddress();

    public boolean isOnline();

    public Component getDisplayName();

    public void setDisplayName(Component var1);

    public MCVersion getVersion();

    public int getPing();

    public GameMode getGameMode();

    public MCGameProfile getGameProfile();

    @Deprecated
    default public MetadataMap metadata() {
        return CommonMetadataRegistries.provide(this.getUUID());
    }

    public String getGameLocale();

    default public Locale getLocale() {
        return Companion.GET_LOCALE.apply(this);
    }

    default public void sendMessage(String message) {
        this.sendMessage(LegacyComponentSerializer.legacy('&').deserialize(message));
    }

    default public void sendMessage(char colorCode, String message) {
        this.sendMessage(LegacyComponentSerializer.legacy(colorCode).deserialize(message));
    }

    default public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(LegacyComponentSerializer.legacy('&').deserialize(message));
        }
    }

    default public void sendMessage(Iterable<String> messages) {
        for (String message : messages) {
            this.sendMessage(LegacyComponentSerializer.legacy('&').deserialize(message));
        }
    }

    default public void sendMessage(char colorCode, String ... messages) {
        for (String message : messages) {
            this.sendMessage(LegacyComponentSerializer.legacy(colorCode).deserialize(message));
        }
    }

    default public void sendMessage(char colorCode, Iterable<String> messages) {
        for (String message : messages) {
            this.sendMessage(LegacyComponentSerializer.legacy(colorCode).deserialize(message));
        }
    }

    public Channel getChannel();

    public static class Companion {
        public static Bridge BRIDGE = null;
        public static Function<MCPlayer, Locale> GET_LOCALE = mcPlayer -> Translator.parseLocale(mcPlayer.getGameLocale());
    }

    public static interface Bridge {
        public UUID from(@NotNull Object var1);

        public MCPlayer find(UUID var1);

        public MCPlayer create(Object var1);

        public Collection<MCPlayer> all();
    }
}

