/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc;

import io.fairyproject.mc.MCPlayer;
import java.util.function.Function;

public class PlaceholderEntry {
    private final String target;
    private final Function<MCPlayer, String> replacement;

    public PlaceholderEntry(String target, String replacement) {
        this.target = target;
        this.replacement = player -> replacement;
    }

    public PlaceholderEntry(String target, Object replacement) {
        this(target, replacement.toString());
    }

    public String getReplacement(MCPlayer player) {
        return this.replacement.apply(player);
    }

    public static PlaceholderEntry entry(String target, String replacement) {
        return new PlaceholderEntry(target, replacement);
    }

    public static PlaceholderEntry entry(String target, Object replacement) {
        return new PlaceholderEntry(target, replacement);
    }

    public static PlaceholderEntry entry(String target, Function<MCPlayer, String> replacement) {
        return new PlaceholderEntry(target, replacement);
    }

    public String getTarget() {
        return this.target;
    }

    public Function<MCPlayer, String> getReplacement() {
        return this.replacement;
    }

    public PlaceholderEntry(String target, Function<MCPlayer, String> replacement) {
        this.target = target;
        this.replacement = replacement;
    }
}

