/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.entity.animation;

import io.fairyproject.libs.packetevents.util.Vector3d;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import io.fairyproject.mc.MCEntity;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.entity.EntityIDCounter;
import io.fairyproject.mc.entity.animation.AbstractFakeEntityAnimation;
import io.fairyproject.mc.protocol.MCProtocol;
import io.fairyproject.mc.util.Position;
import org.jetbrains.annotations.NotNull;

public class FakeEntityDeathAnimation
extends AbstractFakeEntityAnimation {
    public FakeEntityDeathAnimation(@NotNull MCEntity entity) {
        super(entity);
    }

    @Override
    public void start() {
        MCEntity entity = this.getEntity();
        Position pos = entity.getPosition();
        int entityID = EntityIDCounter.current().next();
        if (entity instanceof MCPlayer) {
            this.getViewers().forEach(mcPlayer -> MCProtocol.sendPacket(mcPlayer, new WrapperPlayServerSpawnPlayer(entityID, entity.getUUID(), new Vector3d(pos.getX(), pos.getY(), pos.getZ()), pos.getYaw(), pos.getPitch(), entity.data())));
        }
        this.getViewers().forEach(mcPlayer -> {
            MCProtocol.sendPacket(mcPlayer, new WrapperPlayServerEntityStatus(entityID, 3));
            mcPlayer.getScheduler().schedule(() -> MCProtocol.sendPacket(mcPlayer, new WrapperPlayServerDestroyEntities(entityID)), 20L);
        });
    }
}

