/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.hologram;

import io.fairyproject.mc.MCEntity;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.MCServer;
import io.fairyproject.mc.Viewable;
import io.fairyproject.mc.hologram.HologramImpl;
import io.fairyproject.mc.hologram.configuration.HologramConfiguration;
import io.fairyproject.mc.hologram.line.HologramLine;
import io.fairyproject.mc.util.Position;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Hologram
extends Viewable {
    @NotNull
    public static Hologram create(Position pos) {
        return new HologramImpl(MCServer.current(), HologramConfiguration.hologramEntityFactory, pos);
    }

    @Contract(value="_ -> this")
    public Hologram autoViewable(boolean var1);

    @Contract(value="_ -> this")
    public Hologram viewDistance(int var1);

    @Contract(value="_ -> this")
    public Hologram attackHandler(Consumer<MCPlayer> var1);

    @Contract(value="_ -> this")
    public Hologram interactHandler(Consumer<MCPlayer> var1);

    @Contract(value="_ -> this")
    public Hologram lines(@NotNull List<HologramLine> var1);

    @Contract(value="_ -> this")
    public Hologram line(@NotNull HologramLine var1);

    @Contract(value="_, _ -> this")
    public Hologram line(int var1, @NotNull HologramLine var2);

    @Contract(value="_ -> this")
    public Hologram position(@NotNull Position var1);

    public Hologram verticalSpacing(double var1);

    @Contract(value="_ -> this")
    public Hologram attach(@Nullable MCEntity var1);

    public void removeLine(int var1);

    public void clear();

    @Contract(value=" -> this")
    public Hologram spawn();

    public void remove();

    public boolean isSpawned();

    public boolean isAutoViewable();

    public int getViewDistance();

    @Nullable
    public MCEntity getAttached();

    @NotNull
    public Position getPosition();

    public double getVerticalSpacing();

    @NotNull
    public List<HologramLine> getLines();
}

