/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.hologram;

import io.fairyproject.event.EventListener;
import io.fairyproject.event.EventNode;
import io.fairyproject.libs.packetevents.protocol.packettype.PacketType;
import io.fairyproject.libs.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import io.fairyproject.mc.MCEntity;
import io.fairyproject.mc.MCEventFilter;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.MCServer;
import io.fairyproject.mc.MCWorld;
import io.fairyproject.mc.entity.EntityIDCounter;
import io.fairyproject.mc.event.MCPlayerChangedWorldEvent;
import io.fairyproject.mc.event.MCPlayerJoinEvent;
import io.fairyproject.mc.event.MCPlayerMoveEvent;
import io.fairyproject.mc.event.MCPlayerQuitEvent;
import io.fairyproject.mc.event.trait.MCPlayerEvent;
import io.fairyproject.mc.hologram.Hologram;
import io.fairyproject.mc.hologram.entity.HologramEntity;
import io.fairyproject.mc.hologram.entity.factory.HologramEntityFactory;
import io.fairyproject.mc.hologram.line.HologramLine;
import io.fairyproject.mc.protocol.event.MCPlayerPacketReceiveEvent;
import io.fairyproject.mc.util.Position;
import io.fairyproject.util.ConditionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramImpl
implements Hologram {
    private final MCServer server;
    private final MCWorld world;
    private final HologramEntityFactory entityFactory;
    private Position pos;
    private MCEntity attached;
    private boolean spawned;
    private boolean autoViewable;
    private double verticalSpacing;
    private int viewDistance;
    @Nullable
    private EventNode<MCPlayerEvent> eventNode;
    private final Map<MCPlayer, EventNode<MCPlayerEvent>> viewers;
    private final Set<Consumer<MCPlayer>> attackHandlers;
    private final Set<Consumer<MCPlayer>> interactHandlers;
    private final List<HologramLine> lines;
    private final List<HologramEntity> entities;

    public HologramImpl(@NotNull MCServer server, @NotNull HologramEntityFactory entityFactory, @NotNull Position pos) {
        this.server = server;
        this.entityFactory = entityFactory;
        this.world = pos.getMCWorld();
        this.pos = pos;
        this.autoViewable = true;
        this.verticalSpacing = 0.25;
        this.viewDistance = 4;
        this.lines = new ArrayList<HologramLine>();
        this.entities = new ArrayList<HologramEntity>();
        this.viewers = new ConcurrentHashMap<MCPlayer, EventNode<MCPlayerEvent>>();
        this.attackHandlers = new CopyOnWriteArraySet<Consumer<MCPlayer>>();
        this.interactHandlers = new CopyOnWriteArraySet<Consumer<MCPlayer>>();
    }

    @Override
    public Hologram autoViewable(boolean autoViewable) {
        this.autoViewable = autoViewable;
        return this;
    }

    @Override
    public Hologram viewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        return this;
    }

    @Override
    public Hologram attackHandler(Consumer<MCPlayer> attackHandler) {
        this.attackHandlers.add(attackHandler);
        return this;
    }

    @Override
    public Hologram interactHandler(Consumer<MCPlayer> interactHandler) {
        this.interactHandlers.add(interactHandler);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hologram lines(@NotNull List<HologramLine> lines) {
        HologramImpl hologramImpl = this;
        synchronized (hologramImpl) {
            this.lines.clear();
            this.lines.addAll(lines);
        }
        this.updateEntities();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hologram line(@NotNull HologramLine line) {
        HologramImpl hologramImpl = this;
        synchronized (hologramImpl) {
            this.lines.add(line);
        }
        this.updateEntities();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hologram line(int index, @NotNull HologramLine line) {
        HologramImpl hologramImpl = this;
        synchronized (hologramImpl) {
            this.lines.set(index, line);
        }
        this.updateEntities();
        return this;
    }

    @Override
    public Hologram position(@NotNull Position pos) {
        if (this.pos.getMCWorld() != this.world) {
            throw new IllegalArgumentException("hologram doesn't support cross world teleportation.");
        }
        this.pos = pos;
        this.viewers.keySet().forEach(this::update);
        return this;
    }

    @Override
    public Hologram verticalSpacing(double verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
        return this;
    }

    @Override
    public Hologram attach(@Nullable MCEntity entity) {
        this.attached = entity;
        this.viewers.keySet().forEach(this::update);
        return this;
    }

    @Override
    public void removeLine(int index) {
        this.lines.remove(index);
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hologram spawn() {
        HologramImpl hologramImpl = this;
        synchronized (hologramImpl) {
            if (this.spawned) {
                return this;
            }
            this.spawned = true;
        }
        ConditionUtils.notNull(this.pos, "hologram position");
        this.updateEntities();
        if (this.autoViewable) {
            this.nearby().forEach(this::addViewer);
            EventNode<MCPlayerEvent> eventNode = EventNode.type("hologram:nearby", MCEventFilter.PLAYER);
            eventNode.addListener(MCPlayerJoinEvent.class, event -> {
                MCPlayer player = event.getPlayer();
                if (this.isViewer(player)) {
                    return;
                }
                if (this.chunkDistanceTo(player.getPosition()) <= (double)this.viewDistance) {
                    this.addViewer(player);
                }
            });
            eventNode.addListener(EventListener.builder(MCPlayerMoveEvent.class).ignoreCancelled(true).filter(event -> !this.isViewer(event.getPlayer())).filter(MCEventFilter.DIFFERENT_CHUNK).handler(event -> {
                MCPlayer player = event.getPlayer();
                if (this.chunkDistanceTo(event.getToPos()) <= (double)this.viewDistance) {
                    this.addViewer(player);
                }
            }).build());
            this.world.getEventNode().addChild(eventNode);
            this.eventNode = eventNode;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove() {
        HologramImpl hologramImpl = this;
        synchronized (hologramImpl) {
            if (!this.spawned) {
                return;
            }
            this.viewers.keySet().forEach(this::removeViewer);
            this.spawned = false;
        }
        this.viewers.clear();
        if (this.eventNode != null) {
            this.world.getEventNode().removeChild(this.eventNode);
            this.eventNode = null;
        }
    }

    private synchronized void updateEntities() {
        int index;
        if (!this.spawned) {
            return;
        }
        for (index = 0; index < this.lines.size(); ++index) {
            HologramEntity entity;
            HologramLine line = this.lines.get(index);
            if (index >= this.entities.size()) {
                entity = this.entityFactory.create(this);
                entity.setEntityId(EntityIDCounter.current().next());
                entity.setEntityUuid(UUID.randomUUID());
                entity.setY(-this.verticalSpacing * (double)index);
                entity.setLine(line);
                this.entities.add(entity);
                this.viewers.keySet().forEach(entity::show);
                continue;
            }
            entity = this.entities.get(index);
            entity.setLine(line);
            this.viewers.keySet().forEach(entity::update);
        }
        if (index < this.entities.size() - 1) {
            while (index < this.entities.size()) {
                HologramEntity entity = this.entities.get(index);
                this.entities.remove(entity);
                this.viewers.keySet().forEach(entity::hide);
                ++index;
            }
        }
    }

    @Override
    public boolean isSpawned() {
        return this.spawned;
    }

    @Override
    public boolean isAutoViewable() {
        return this.autoViewable;
    }

    @Override
    public int getViewDistance() {
        return this.viewDistance;
    }

    @Override
    @Nullable
    public MCEntity getAttached() {
        return this.attached;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.pos;
    }

    @Override
    public double getVerticalSpacing() {
        return this.verticalSpacing;
    }

    @Override
    @NotNull
    public List<HologramLine> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    @Override
    public boolean addViewer(@NotNull MCPlayer player) {
        if (this.spawned) {
            this.show(player);
        }
        return this.viewers.put(player, this.createEventNode(player)) != null;
    }

    private EventNode<MCPlayerEvent> createEventNode(MCPlayer player) {
        EventNode<MCPlayerEvent> eventNode = EventNode.type("hologram:player-update", MCEventFilter.PLAYER);
        eventNode.addListener(EventListener.builder(MCPlayerMoveEvent.class).ignoreCancelled(true).filter(MCEventFilter.DIFFERENT_CHUNK).handler(event -> {
            if (this.chunkDistanceTo(player.getPosition()) <= (double)this.viewDistance) {
                return;
            }
            this.removeViewer(player);
        }).build());
        eventNode.addListener(MCPlayerQuitEvent.class, event -> this.removeViewer(event.getPlayer()));
        eventNode.addListener(MCPlayerChangedWorldEvent.class, event -> this.removeViewer(event.getPlayer()));
        eventNode.addListener(MCPlayerPacketReceiveEvent.class, event -> {
            if (event.packetType() != PacketType.Play.Client.INTERACT_ENTITY) {
                return;
            }
            WrapperPlayClientInteractEntity packet = new WrapperPlayClientInteractEntity(event.getEvent());
            if (!this.isEntity(packet.getEntityId())) {
                return;
            }
            switch (packet.getAction()) {
                case ATTACK: {
                    this.attackHandlers.forEach(consumer -> consumer.accept(player));
                    break;
                }
                case INTERACT: 
                case INTERACT_AT: {
                    this.interactHandlers.forEach(consumer -> consumer.accept(player));
                    break;
                }
                default: {
                    throw new IllegalStateException("packet action is null");
                }
            }
        });
        player.getEventNode().addChild(eventNode);
        return eventNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEntity(int entityId) {
        HologramImpl hologramImpl = this;
        synchronized (hologramImpl) {
            return this.entities.stream().anyMatch(entity -> entity.getEntityId() == entityId);
        }
    }

    private void show(@NotNull MCPlayer player) {
        this.entities.forEach(entity -> entity.show(player));
    }

    private void update(@NotNull MCPlayer player) {
        this.entities.forEach(entity -> entity.update(player));
    }

    private void hide(@NotNull MCPlayer player) {
        this.entities.forEach(entity -> entity.hide(player));
    }

    @Override
    public boolean removeViewer(@NotNull MCPlayer player) {
        EventNode<MCPlayerEvent> eventNode;
        if (this.spawned) {
            this.hide(player);
        }
        if ((eventNode = this.viewers.remove(player)) != null) {
            player.getEventNode().removeChild(eventNode);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull MCPlayer> getViewers() {
        return this.viewers.keySet();
    }

    private Stream<MCPlayer> nearby() {
        return this.world.getPlayers().stream().filter(player -> this.chunkDistanceTo(player.getPosition()) <= (double)this.viewDistance);
    }

    private double chunkDistanceTo(Position target) {
        int hologramChunkX = this.pos.getChunkX();
        int hologramChunkZ = this.pos.getChunkZ();
        int targetChunkX = target.getChunkX();
        int targetChunkZ = target.getChunkZ();
        return Math.sqrt(Math.pow(hologramChunkX - targetChunkX, 2.0) + Math.pow(hologramChunkZ - targetChunkZ, 2.0));
    }

    public MCServer getServer() {
        return this.server;
    }
}

