/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.hologram.entity.impl;

import io.fairyproject.libs.packetevents.PacketEvents;
import io.fairyproject.libs.packetevents.manager.server.ServerVersion;
import io.fairyproject.libs.packetevents.protocol.entity.data.EntityData;
import io.fairyproject.libs.packetevents.protocol.entity.data.EntityDataTypes;
import io.fairyproject.libs.packetevents.protocol.entity.type.EntityTypes;
import io.fairyproject.libs.packetevents.util.Vector3d;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerAttachEntity;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import io.fairyproject.mc.MCAdventure;
import io.fairyproject.mc.MCEntity;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.hologram.HologramImpl;
import io.fairyproject.mc.hologram.entity.impl.AbstractHologramEntity;
import io.fairyproject.mc.protocol.MCProtocol;
import io.fairyproject.mc.util.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TextDisplayHologramEntity
extends AbstractHologramEntity {
    public TextDisplayHologramEntity(HologramImpl hologram) {
        super(hologram);
    }

    @Override
    public void show(MCPlayer player) {
        Position pos = this.hologram.getPosition();
        WrapperPlayServerSpawnEntity packet = new WrapperPlayServerSpawnEntity(this.entityId, Optional.of(this.entityUuid), EntityTypes.TEXT_DISPLAY, this.packetPosition(), pos.getPitch(), pos.getYaw(), pos.getYaw(), 0, Optional.of(new Vector3d()));
        MCProtocol.sendPacket(player, packet);
        this.update(player);
    }

    @Override
    public void update(MCPlayer player) {
        MCEntity attached = this.hologram.getAttached();
        WrapperPlayServerEntityTeleport packet = new WrapperPlayServerEntityTeleport(this.entityId, this.packetPosition(), this.hologram.getPosition().getYaw(), this.hologram.getPosition().getPitch(), false);
        WrapperPlayServerEntityMetadata metadataPacket = new WrapperPlayServerEntityMetadata(this.entityId, this.createEntityData(player));
        WrapperPlayServerAttachEntity attachEntityPacket = new WrapperPlayServerAttachEntity(this.entityId, attached != null ? attached.getId() : -1, false);
        MCProtocol.sendPacket(player, packet);
        MCProtocol.sendPacket(player, metadataPacket);
        MCProtocol.sendPacket(player, attachEntityPacket);
    }

    @Override
    public void hide(MCPlayer player) {
        WrapperPlayServerDestroyEntities packet = new WrapperPlayServerDestroyEntities(this.entityId);
        MCProtocol.sendPacket(player, packet);
    }

    private List<EntityData<?>> createEntityData(MCPlayer mcPlayer) {
        boolean modern = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2);
        ArrayList entityDataList = new ArrayList();
        entityDataList.add(new EntityData<String>(modern ? 23 : 22, EntityDataTypes.COMPONENT, MCAdventure.asItemString(this.line.render(mcPlayer), mcPlayer.getLocale())));
        entityDataList.add(new EntityData<Integer>(modern ? 24 : 23, EntityDataTypes.INT, 200));
        entityDataList.add(new EntityData<Integer>(modern ? 25 : 24, EntityDataTypes.INT, 0x40000000));
        entityDataList.add(new EntityData<Byte>(modern ? 26 : 25, EntityDataTypes.BYTE, (byte)-1));
        boolean hasShadow = true;
        boolean isSeeThrough = false;
        boolean useDefaultBackgroundColor = true;
        int alignment = 0;
        entityDataList.add(new EntityData<Byte>(modern ? 27 : 26, EntityDataTypes.BYTE, (byte)((hasShadow ? 1 : 0) | (isSeeThrough ? 2 : 0) | (useDefaultBackgroundColor ? 4 : 0) | alignment)));
        return entityDataList;
    }
}

