/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.tablist;

import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.libs.packetevents.protocol.player.GameMode;
import io.fairyproject.libs.packetevents.protocol.player.TextureProperty;
import io.fairyproject.libs.packetevents.protocol.player.UserProfile;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerPlayerListHeaderAndFooter;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.protocol.MCProtocol;
import io.fairyproject.mc.tablist.TabEntry;
import io.fairyproject.mc.tablist.Tablist;
import io.fairyproject.mc.tablist.util.Skin;
import io.fairyproject.mc.version.MCVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.stream.Collectors;

public class TablistSender {
    private final MCVersion newVersion = MCVersion.of(19, 3);

    public void addFakePlayer(Tablist tablist, Collection<TabEntry> tabEntries) {
        MCPlayer player = tablist.getPlayer();
        if (player.getVersion().isHigherOrEqual(this.newVersion)) {
            WrapperPlayServerPlayerInfoUpdate packet = new WrapperPlayServerPlayerInfoUpdate(EnumSet.of(WrapperPlayServerPlayerInfoUpdate.Action.ADD_PLAYER, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_DISPLAY_NAME, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LISTED), tabEntries.stream().map(this::createModern).collect(Collectors.toList()));
            MCProtocol.sendPacket(player, packet);
        } else {
            WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.ADD_PLAYER, tabEntries.stream().map(this::createLegacy).collect(Collectors.toList()));
            MCProtocol.sendPacket(player, packet);
        }
    }

    public void removeFakePlayer(Tablist tablist, Collection<TabEntry> tabEntries) {
        MCPlayer player = tablist.getPlayer();
        if (player.getVersion().isHigherOrEqual(this.newVersion)) {
            WrapperPlayServerPlayerInfoRemove packet = new WrapperPlayServerPlayerInfoRemove(tabEntries.stream().map(TabEntry::getUuid).collect(Collectors.toList()));
            MCProtocol.sendPacket(player, packet);
        } else {
            WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER, tabEntries.stream().map(this::createLegacy).collect(Collectors.toList()));
            MCProtocol.sendPacket(player, packet);
        }
    }

    public void updateFakeName(Tablist tablist, TabEntry tabEntry, Component text) {
        if (tabEntry.getText().equals(text)) {
            return;
        }
        tabEntry.setText(text);
        MCPlayer player = tablist.getPlayer();
        if (player.getVersion().isHigherOrEqual(this.newVersion)) {
            WrapperPlayServerPlayerInfoUpdate packet = new WrapperPlayServerPlayerInfoUpdate(WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_DISPLAY_NAME, Collections.singletonList(this.createModern(tabEntry)));
            MCProtocol.sendPacket(player, packet);
        } else {
            WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.UPDATE_DISPLAY_NAME, this.createLegacy(tabEntry));
            MCProtocol.sendPacket(player, packet);
        }
    }

    public void updateFakeLatency(Tablist tablist, TabEntry tabEntry, int latency) {
        if (tabEntry.getLatency() == latency) {
            return;
        }
        tabEntry.setLatency(latency);
        MCPlayer player = tablist.getPlayer();
        if (player.getVersion().isHigherOrEqual(this.newVersion)) {
            WrapperPlayServerPlayerInfoUpdate packet = new WrapperPlayServerPlayerInfoUpdate(WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LATENCY, Collections.singletonList(this.createModern(tabEntry)));
            MCProtocol.sendPacket(player, packet);
        } else {
            WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.UPDATE_LATENCY, this.createLegacy(tabEntry));
            MCProtocol.sendPacket(player, packet);
        }
    }

    public void updateFakeSkin(Tablist tablist, TabEntry tabEntry, Skin skin) {
        if (tabEntry.getTexture().equals(skin)) {
            return;
        }
        tabEntry.setTexture(skin);
        this.removeFakePlayer(tablist, Collections.singletonList(tabEntry));
        this.addFakePlayer(tablist, Collections.singletonList(tabEntry));
    }

    public void updateHeaderAndFooter(Tablist tablist, Component header, Component footer) {
        MCPlayer player = tablist.getPlayer();
        WrapperPlayServerPlayerListHeaderAndFooter packet = new WrapperPlayServerPlayerListHeaderAndFooter(header, footer);
        MCProtocol.sendPacket(player, packet);
    }

    private UserProfile getGameProfile(TabEntry tabEntry) {
        UserProfile userProfile = new UserProfile(tabEntry.getUuid(), tabEntry.getId());
        if (tabEntry.getTexture() != null) {
            userProfile.setTextureProperties(Collections.singletonList(new TextureProperty("textures", tabEntry.getTexture().skinValue, tabEntry.getTexture().skinSignature)));
        }
        return userProfile;
    }

    private WrapperPlayServerPlayerInfoUpdate.PlayerInfo createModern(TabEntry tabEntry) {
        return new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(this.getGameProfile(tabEntry), true, tabEntry.getLatency(), GameMode.SURVIVAL, tabEntry.getText(), null);
    }

    private WrapperPlayServerPlayerInfo.PlayerData createLegacy(TabEntry tabEntry) {
        return new WrapperPlayServerPlayerInfo.PlayerData(tabEntry.getText(), this.getGameProfile(tabEntry), GameMode.SURVIVAL, tabEntry.getLatency());
    }
}

