/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.version;

import io.fairyproject.libs.gson.JsonObject;
import io.fairyproject.mc.version.MCVersion;

public class MCVersionMapping {
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean nmsPrefix;
    private final boolean hexColorSupport;
    private final int protocolVersion;

    public MCVersionMapping(int major, int minor, int patch, JsonObject jsonObject) {
        this(major, minor, patch, jsonObject.get("nmsPrefix").getAsBoolean(), jsonObject.get("hexColorSupport").getAsBoolean(), jsonObject.get("protocolVersion").getAsInt());
    }

    public MCVersion toMCVersion() {
        return MCVersion.of(this.major, this.minor, this.patch);
    }

    public MCVersionMapping(int major, int minor, int patch, boolean nmsPrefix, boolean hexColorSupport, int protocolVersion) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.nmsPrefix = nmsPrefix;
        this.hexColorSupport = hexColorSupport;
        this.protocolVersion = protocolVersion;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isNmsPrefix() {
        return this.nmsPrefix;
    }

    public boolean isHexColorSupport() {
        return this.hexColorSupport;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MCVersionMapping)) {
            return false;
        }
        MCVersionMapping other = (MCVersionMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getPatch() != other.getPatch()) {
            return false;
        }
        if (this.isNmsPrefix() != other.isNmsPrefix()) {
            return false;
        }
        if (this.isHexColorSupport() != other.isHexColorSupport()) {
            return false;
        }
        return this.getProtocolVersion() == other.getProtocolVersion();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MCVersionMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getPatch();
        result = result * 59 + (this.isNmsPrefix() ? 79 : 97);
        result = result * 59 + (this.isHexColorSupport() ? 79 : 97);
        result = result * 59 + this.getProtocolVersion();
        return result;
    }

    public String toString() {
        return "MCVersionMapping(major=" + this.getMajor() + ", minor=" + this.getMinor() + ", patch=" + this.getPatch() + ", nmsPrefix=" + this.isNmsPrefix() + ", hexColorSupport=" + this.isHexColorSupport() + ", protocolVersion=" + this.getProtocolVersion() + ")";
    }
}

