/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.metadata;

import io.fairyproject.metadata.Empty;
import io.fairyproject.metadata.MetadataKeyImpl;
import java.util.Objects;
import java.util.UUID;

public interface MetadataKey<T> {
    public static <T> MetadataKey<T> create(String id, Class<T> type) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(type, "type");
        return new MetadataKeyImpl<T>(id, type);
    }

    public static MetadataKey<Empty> createEmptyKey(String id) {
        return MetadataKey.create(id, Empty.class);
    }

    public static MetadataKey<String> createStringKey(String id) {
        return MetadataKey.create(id, String.class);
    }

    public static MetadataKey<Boolean> createBooleanKey(String id) {
        return MetadataKey.create(id, Boolean.class);
    }

    public static MetadataKey<Integer> createIntegerKey(String id) {
        return MetadataKey.create(id, Integer.class);
    }

    public static MetadataKey<Long> createLongKey(String id) {
        return MetadataKey.create(id, Long.class);
    }

    public static MetadataKey<Double> createDoubleKey(String id) {
        return MetadataKey.create(id, Double.class);
    }

    public static MetadataKey<Float> createFloatKey(String id) {
        return MetadataKey.create(id, Float.class);
    }

    public static MetadataKey<Short> createShortKey(String id) {
        return MetadataKey.create(id, Short.class);
    }

    public static MetadataKey<Character> createCharacterKey(String id) {
        return MetadataKey.create(id, Character.class);
    }

    public static MetadataKey<UUID> createUuidKey(String id) {
        return MetadataKey.create(id, UUID.class);
    }

    public String getId();

    public Class<T> getType();

    public T cast(Object var1) throws ClassCastException;
}

