/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.plugin;

import io.fairyproject.container.node.ContainerNode;
import io.fairyproject.internal.FairyInternalIdentityMeta;
import io.fairyproject.plugin.PluginAction;
import io.fairyproject.plugin.PluginClassLoaderRegistry;
import io.fairyproject.plugin.PluginDescription;
import io.fairyproject.util.ConditionUtils;
import io.fairyproject.util.terminable.Terminable;
import io.fairyproject.util.terminable.TerminableConsumer;
import io.fairyproject.util.terminable.composite.CompositeTerminable;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

@FairyInternalIdentityMeta
public abstract class Plugin
implements TerminableConsumer,
Terminable {
    private final CompositeTerminable compositeTerminable = CompositeTerminable.create();
    private final PluginClassLoaderRegistry classLoaderRegistry = new PluginClassLoaderRegistry();
    private ClassLoader classLoader;
    private PluginDescription description;
    private PluginAction action;
    private ContainerNode node;

    public void onInitial() {
    }

    public void onPreEnable() {
    }

    public void onPluginEnable() {
    }

    public void onPluginDisable() {
    }

    public void onFrameworkFullyDisable() {
    }

    public final void initializePlugin(PluginDescription description, PluginAction action, ClassLoader classLoader) {
        this.description = description;
        this.action = action;
        this.classLoader = classLoader;
        this.classLoaderRegistry.addUrl(this.getClass().getProtectionDomain().getCodeSource().getLocation());
        this.classLoaderRegistry.addClassLoader(this.getPluginClassLoader());
    }

    @Override
    @NotNull
    public <T extends Terminable> T bind(@NotNull T terminable) {
        return this.compositeTerminable.bind(terminable);
    }

    public final ClassLoader getPluginClassLoader() {
        return this.classLoader;
    }

    public final String getName() {
        return this.description.getName();
    }

    public Path getDataFolder() {
        return this.action.getDataFolder();
    }

    @Override
    public void close() throws Exception {
        ConditionUtils.notNull(this.action, "The plugin hasn't been initialized.");
        this.action.close();
        this.action = null;
    }

    @Override
    public boolean isClosed() {
        return this.action == null || this.action.isClosed();
    }

    public CompositeTerminable getCompositeTerminable() {
        return this.compositeTerminable;
    }

    public PluginClassLoaderRegistry getClassLoaderRegistry() {
        return this.classLoaderRegistry;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public PluginDescription getDescription() {
        return this.description;
    }

    public PluginAction getAction() {
        return this.action;
    }

    public ContainerNode getNode() {
        return this.node;
    }

    public void setNode(ContainerNode node) {
        this.node = node;
    }
}

