/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.plugin.initializer;

import io.fairyproject.plugin.Plugin;
import io.fairyproject.plugin.initializer.PluginClassInitializer;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;

public class DefaultPluginClassInitializer
implements PluginClassInitializer {
    @Override
    @NotNull
    public ClassLoader initializeClassLoader(@NotNull String name, @NotNull ClassLoader classLoader) {
        return classLoader;
    }

    @Override
    public Plugin create(String mainClassPath, ClassLoader classLoader) {
        Class<?> mainClass;
        try {
            mainClass = classLoader.loadClass(mainClassPath);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load mainClass " + mainClassPath, e);
        }
        if (!Plugin.class.isAssignableFrom(mainClass)) {
            throw new IllegalStateException(String.format("%s wasn't implementing Plugin", mainClass));
        }
        try {
            return (Plugin)mainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to new instance " + mainClassPath + " (Does it has no args constructor in the class?)", e);
        }
    }
}

