/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.scheduler.repeat;

import io.fairyproject.scheduler.ScheduledTask;
import io.fairyproject.scheduler.repeat.CycledRepeatPredicate;
import io.fairyproject.scheduler.repeat.EmptyRepeatPredicate;
import io.fairyproject.scheduler.repeat.LengthRepeatPredicate;
import java.time.Duration;

public interface RepeatPredicate<T> {
    public static <T> RepeatPredicate<T> cycled(int cycles) {
        return new CycledRepeatPredicate<Object>(cycles, null);
    }

    public static <T> RepeatPredicate<T> cycled(int cycles, T defaultValue) {
        return new CycledRepeatPredicate<T>(cycles, defaultValue);
    }

    public static <T> RepeatPredicate<T> length(long startTime, Duration duration, T defaultValue) {
        return new LengthRepeatPredicate<T>(startTime, duration, defaultValue);
    }

    public static <T> RepeatPredicate<T> length(Duration duration, T defaultValue) {
        return RepeatPredicate.length(System.currentTimeMillis(), duration, defaultValue);
    }

    public static <T> RepeatPredicate<T> length(Duration duration) {
        return RepeatPredicate.length(duration, null);
    }

    public static <T> RepeatPredicate<T> empty() {
        return new EmptyRepeatPredicate();
    }

    public boolean shouldContinue(ScheduledTask<?> var1);

    public T getDefaultValue();
}

