/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.sidebar;

import io.fairyproject.data.MetaKey;
import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.sidebar.SidebarLine;
import io.fairyproject.sidebar.SidebarProvider;
import io.fairyproject.sidebar.handler.SidebarHandler;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Sidebar {
    public static final MetaKey<Sidebar> METADATA_TAG = MetaKey.create("fairy:Scoreboard", Sidebar.class);
    private static final int MAX_LINES = 15;
    private final MCPlayer player;
    private final SidebarHandler sidebarHandler;
    private final SidebarLine[] lines;
    private Component title;
    private int ticks;
    private boolean available;
    private SidebarProvider provider;

    public Sidebar(@NotNull MCPlayer player, @NotNull SidebarHandler sidebarHandler) {
        this.player = player;
        this.sidebarHandler = sidebarHandler;
        this.lines = new SidebarLine[16];
    }

    public void setTitle(@NotNull Component title) {
        if (Objects.equals(this.title, title)) {
            return;
        }
        this.title = title;
        if (!this.available) {
            this.available = true;
            this.sidebarHandler.sendObjective(this);
        } else {
            this.sidebarHandler.sendTitle(this);
        }
    }

    public void setLines(List<SidebarLine> lines) {
        int i;
        int lineCount = 1;
        for (i = lines.size() - 1; i >= 0; --i) {
            this.setLine(lineCount, lines.get(i));
            ++lineCount;
        }
        for (i = lines.size(); i < 15; ++i) {
            if (this.lines[lineCount] != null) {
                this.clear(lineCount);
            }
            ++lineCount;
        }
    }

    private void setLine(int index, @NotNull SidebarLine line) {
        if (index < 1 || index > 15) {
            return;
        }
        if (Objects.equals(this.lines[index], line)) {
            return;
        }
        this.sidebarHandler.sendLine(this, index, line);
        this.lines[index] = line;
    }

    @Nullable
    public SidebarLine getLine(int line) {
        if (line < 1 || line > 15) {
            return null;
        }
        return this.lines[line];
    }

    public void clear(int line) {
        if (line < 1 || line > 15) {
            return;
        }
        if (this.lines[line] == null) {
            return;
        }
        this.sidebarHandler.removeLine(this, line);
        this.lines[line] = null;
    }

    public void remove() {
        if (!this.available) {
            return;
        }
        this.available = false;
        for (int line = 1; line < 15; ++line) {
            this.clear(line);
        }
        this.title = null;
        this.provider = null;
        this.sidebarHandler.removeObjective(this);
    }

    public MCPlayer getPlayer() {
        return this.player;
    }

    public SidebarHandler getSidebarHandler() {
        return this.sidebarHandler;
    }

    public SidebarLine[] getLines() {
        return this.lines;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getTicks() {
        return this.ticks;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public SidebarProvider getProvider() {
        return this.provider;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setProvider(SidebarProvider provider) {
        this.provider = provider;
    }
}

