/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.state;

import io.fairyproject.event.EventNode;
import io.fairyproject.state.Signal;
import io.fairyproject.state.StateHandler;
import io.fairyproject.state.event.StateEvent;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface StateConfigBuilder {
    @NotNull
    public EventNode<StateEvent> eventNode();

    @Contract(value="_ -> this")
    @NotNull
    public StateConfigBuilder handler(@NotNull StateHandler var1);

    @Contract(value="_ -> this")
    @NotNull
    default public StateConfigBuilder handleStart(@NotNull Runnable runnable) {
        return this.handler(StateHandler.builder().onStart(runnable).build());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public StateConfigBuilder handleTick(@NotNull Runnable runnable) {
        return this.handler(StateHandler.builder().onTick(runnable).build());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public StateConfigBuilder handleStop(@NotNull Runnable runnable) {
        return this.handler(StateHandler.builder().onStop(runnable).build());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public StateConfigBuilder handleStart(@NotNull Consumer<Signal> consumer) {
        return this.handler(StateHandler.builder().onStart(consumer).build());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public StateConfigBuilder handleStop(@NotNull Consumer<Signal> consumer) {
        return this.handler(StateHandler.builder().onStop(consumer).build());
    }
}

