/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.state.impl;

import io.fairyproject.event.EventNode;
import io.fairyproject.state.State;
import io.fairyproject.state.StateConfig;
import io.fairyproject.state.StateConfigBuilder;
import io.fairyproject.state.StateHandler;
import io.fairyproject.state.StateMachine;
import io.fairyproject.state.event.StateEvent;
import io.fairyproject.state.event.StateEventFilter;
import io.fairyproject.state.event.StateMachineEvent;
import io.fairyproject.state.impl.StateConfigImpl;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StateConfigBuilderImpl
implements StateConfigBuilder {
    private final State state;
    private final EventNode<StateEvent> eventNode;
    private final List<StateHandler> handlers = new ArrayList<StateHandler>();

    public StateConfigBuilderImpl(@NotNull State state, @NotNull EventNode<StateMachineEvent> eventNode) {
        this.state = state;
        this.eventNode = eventNode.map(state, StateEventFilter.STATE);
    }

    @Override
    @NotNull
    public EventNode<StateEvent> eventNode() {
        return this.eventNode;
    }

    @Override
    @NotNull
    public StateConfigBuilder handler(@NotNull StateHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    public StateConfig build(StateMachine stateMachine) {
        return new StateConfigImpl(this.state, stateMachine, this.handlers, this.eventNode);
    }
}

